import arhiplexpy


if __name__ == "__main__":
    model = arhiplexpy.Model()
    
    x1 = model.add_variable(0.0, arhiplexpy.kArhiplexInf, 0.75, arhiplexpy.variable_type.continuous, 'Carrot')
    x2 = model.add_variable(0.0, arhiplexpy.kArhiplexInf, 0.5, arhiplexpy.variable_type.continuous, 'WhiteCabbage')
    x3 = model.add_variable(0.0, arhiplexpy.kArhiplexInf, 0.15, arhiplexpy.variable_type.continuous, 'Cucumber')
    
    model.add_constraint(35 * x1 + 0.5 * x2 + 0.5 * x3 >= 0.5, 'VitaminA')
    model.add_constraint(60 * x1 + 300 * x2 + 10 * x3 >= 15, 'VitaminC')
    model.add_constraint(30 * x1 + 20 * x2 + 10 * x3 >= 4, 'DietaryFiber')
    
    model.set_objective_sense(arhiplexpy.objective_sense.minimize)
    
    result = model.solve()
    
    print('Optimal price for diet problem:', f'{result.get_objective_value():.2f}', 'EUR')
    print('Carrot:', f'{1000 * result.get_variable_value(x1):.2f}', 'g')
    print('WhiteCabbage:', f'{1000 * result.get_variable_value(x2):.2f}', 'g')
    print('Cucumber:', f'{1000 * result.get_variable_value(x3):.2f}', 'g')
