# Maximize  x1 + 2 x2 + 3 x3 + x4
#   Subject to
#      - x1 +   x2 + x3 + 10 x4 <= 20
#        x1 - 3 x2 + x3         <= 30
#               x2      - 3.5x4  = 0
#   Bounds
#        0 <= x1 <= 40
#        0 <= x2
#        0 <= x3
#        2 <= x4 <= 3
#   Integers
#       x4

import arhiplexpy

if __name__ == "__main__":
    model = arhiplexpy.Model()

    model.set_dbl_param("mip_rel_gap", 0.1)

    x1 = model.add_variable(0, 40, 1, arhiplexpy.variable_type.continuous, 'x1')
    x2 = model.add_variable(0, arhiplexpy.kArhiplexInf, 2, arhiplexpy.variable_type.continuous, 'x2')
    x3 = model.add_variable(0, arhiplexpy.kArhiplexInf, 3, arhiplexpy.variable_type.continuous, 'x3')
    x4 = model.add_variable(2, 3, 1, arhiplexpy.variable_type.integer, 'x4')

    model.add_constraint(-x1 + x2 + x3 + 10 * x4 <= 20, 'c1')
    model.add_constraint(x1 - 3 * x2 + x3 <= 30, 'c2')
    model.add_constraint(x2 - 3.5 * x4 == 0, 'c3')

    model.set_objective_sense(arhiplexpy.objective_sense.maximize)

    result = model.solve_remote(name_mapping_file="test.map")

    if result.get_solve_result() == arhiplexpy.solve_result.success and \
            (result.get_solution_status() == arhiplexpy.solution_status.optimal or \
             result.get_solution_status() == arhiplexpy.solution_status.feasible):
        print('Objective value:', result.get_objective_value())
        print('x1:', result.get_variable_value(x1))
        print('x2:', result.get_variable_value(x2))
        print('x3:', result.get_variable_value(x3))
        print('x4:', result.get_variable_value(x4))
    else:
        print(result.get_solution_status())