import arhiplexpy


if __name__ == "__main__":
    model = arhiplexpy.Model()

    model.read("blp-ic98.mps")
    model.set_dbl_param("mip_rel_gap", 0.1)
    model.set_dbl_param("time_limit", 70)
    model.set_log_file("arhi_cloud.log")

    result = model.solve_remote("name_mapping.txt")
    uid = model.get_calc_uid()

    result.write_solution("blp-ic98.sol")

    result_by_uid = arhiplexpy.SolveResult(uid, "name_mapping.txt")

    print("Objective:", result_by_uid.get_objective_value())
    print("Solve time:", result_by_uid.get_solve_time())
