#include "arhiplex_client.h"
#include <iostream>
/*
\ Equation counts
\     Total        E        G        L        N        X        C        B
\        41       39        0        2        0        0        0        0
\
\ Variable counts
\                  x        b        i      s1s      s2s       sc       si
\     Total     cont   binary  integer     sos1     sos2    scont     sint
\        48       46        2        0        0        0        0        0
\
\ Nonzero counts
\     Total    const       NL      DLL
\       180       70      110        0
\
Minimize
obj : -0.0139904 x2 - 0.0661588 x3 + 0 x4 + 0 x5 + 0 x6 + 0 x7 + 0.23947 b8 + 0.75835 b9 + 0 x10 + 0 x11
+ 0 x12 + 0 x13 + 0 x14 + 0 x15 + 0 x16 + 0 x17 + 0 x18 + 0 x19 + 0 x20 + 0 x21 + 0 x22 + 0 x23 + 0 x24
+ 0 x25 + 0 x26 + 0 x27 + 0 x28 + 0 x29 + 0 x30 + 0 x31 + 0 x32 + 0 x33 + 0 x34 + 0 x35 + 0 x36 + 0 x37
+ 0 x38 + 0 x39 + 0 x40 + 0 x41 + 0 x42 + 0 x43 + 0 x44 + 0 x45 + 0 x46 + 0 x47 + 0 x48 + 0 x49 + [
    0.0187028 x2 * x4 + 0.0154616 x2 * x5 - 0.0011438 x2 * x16 + 0.0085312 x2 * x17 + 0.0676294 x3 * x6
        + 0.0746698 x3 * x7 + 0.0032742 x3 * x18 + 0.0577992 x3 * x19] / 2

    Subject To
        e2 : x20 + x21 + x22 + x23 = 300
        e3 : x24 - x25 - x26 = 0
        e4 : x27 - x28 - x29 - x30 = 0
        e5 : x31 - x32 - x33 - x34 = 0
        e6 : x35 - x36 - x37 = 0
        e7 : x38 + x39 = 1
        e8 : x40 + x41 + x42 = 1
        e9 : x43 + x44 + x45 = 1
        e10 : x46 + x47 = 1
        e11 : x16 + x17 + x48 = 1
        e12 : x18 + x19 + x49 = 1
        e13 : x2 - 300 b8 <= 0
        e14 : x3 - 300 b9 <= 0
        e15 : x10 - 0.3333333333 x20 + [-x32 * x43] = 0
        e16 : x11 - 0.3333333333 x20 + [-x32 * x44] = 0
        e17 : x12 - 0.3333333333 x20 + [-x32 * x45] = 0
        e18 : x13 - 0.3333333333 x21 + [-x28 * x40] = 0
        e19 : x14 - 0.3333333333 x21 + [-x28 * x41] = 0
        e20 : x15 - 0.3333333333 x21 + [-x28 * x42] = 0
        e21 : x10 + [-x24 * x38 - x27 * x40] = 0
        e22 : x11 + [-x24 * x39 - x27 * x41] = 0
        e23 : x12 + [-x27 * x42] = 0
        e24 : x13 + [-x31 * x43] = 0
        e25 : x14 + [-x31 * x44 - x35 * x46] = 0
        e26 : x15 + [-x31 * x45 - x35 * x47] = 0
        e27 : 0.3333333333 x22 + [x25 * x38 + x29 * x40 + x33 * x43] = 80
        e28 : 0.3333333333 x22 + [x25 * x39 + x29 * x41 + x33 * x44 + x36 * x46] = 30
        e29 : 0.3333333333 x22 + [x29 * x42 + x33 * x45 + x36 * x47] = 20
        e30 : 0.3333333333 x23 + [x26 * x38 + x30 * x40 + x34 * x43] = 20
        e31 : 0.3333333333 x23 + [x26 * x39 + x30 * x41 + x34 * x44 + x37 * x46] = 70
        e32 : 0.3333333333 x23 + [x30 * x42 + x34 * x45 + x37 * x47] = 80
        e33 : -x10 + [x2 * x16] = 0
        e34 : -x11 + [x2 * x17] = 0
        e35 : -x12 + [x2 * x48] = 0
        e36 : -x13 + [x3 * x18] = 0
        e37 : -x14 + [x3 * x19] = 0
        e38 : -x15 + [x3 * x49] = 0
        e39 : [x4 * x10 - x24 * x38] = 0
        e40 : [x5 * x11 - x27 * x41] = 0
        e41 : [x6 * x14 - x31 * x44] = 0
        e42 : [x7 * x15 - x35 * x47] = 0

        Bounds
        x2 <= 300
        x3 <= 300
        0.85 <= x4 <= 1
        0.85 <= x5 <= 1
        0.85 <= x6 <= 1
        0.85 <= x7 <= 1
        x10 <= 100
        x11 <= 100
        x12 <= 100
        x13 <= 100
        x14 <= 100
        x15 <= 100
        x16 <= 1
        x17 <= 1
        x18 <= 1
        x19 <= 1
        x20 <= 300
        x21 <= 300
        x24 <= 300
        x25 <= 300
        x26 <= 300
        x27 <= 300
        x28 <= 300
        x29 <= 300
        x30 <= 300
        x31 <= 300
        x32 <= 300
        x33 <= 300
        x34 <= 300
        x35 <= 300
        x36 <= 300
        x37 <= 300
        x38 <= 1
        x39 <= 1
        x40 <= 1
        x41 <= 1
        x42 <= 1
        x43 <= 1
        x44 <= 1
        x45 <= 1
        x46 <= 1
        x47 <= 1
        x48 <= 1
        x49 <= 1

        Binary
        b8 b9

        End
*/

int main(int argc, char *argv[])
{
  try
  {
    setlocale(LC_CTYPE, "Russian");
    using namespace arhiplex;
    arhiplex::Model model;
    //Как пример - для данной простой модели не актуально
    model.SetDblParam("time_limit", 30.0); //10 сек
    model.SetDblParam("mip_rel_gap", 0.00001); //0.01%

    // Добавление переменных
    auto b8 = model.AddVariable(0.0, 1.0, 0.0, variable_type::binary, "b8");
    auto b9 = model.AddVariable(0.0, 1.0, 0.0, variable_type::binary, "b9");
    auto x2 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x2");
    auto x3 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x3");
    auto x4 = model.AddVariable(0.85, 1.0, 0.0, variable_type::continuous, "x4");
    auto x5 = model.AddVariable(0.85, 1.0, 0.0, variable_type::continuous, "x5");
    auto x6 = model.AddVariable(0.85, 1.0, 0.0, variable_type::continuous, "x6");
    auto x7 = model.AddVariable(0.85, 1.0, 0.0, variable_type::continuous, "x7");
    auto x10 = model.AddVariable(0.0, 100.0, 0.0, variable_type::continuous, "x10");
    auto x11 = model.AddVariable(0.0, 100.0, 0.0, variable_type::continuous, "x11");
    auto x12 = model.AddVariable(0.0, 100.0, 0.0, variable_type::continuous, "x12");
    auto x13 = model.AddVariable(0.0, 100.0, 0.0, variable_type::continuous, "x13");
    auto x14 = model.AddVariable(0.0, 100.0, 0.0, variable_type::continuous, "x14");
    auto x15 = model.AddVariable(0.0, 100.0, 0.0, variable_type::continuous, "x15");
    auto x16 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x16");
    auto x17 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x17");
    auto x18 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x18");
    auto x19 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x19");
    auto x20 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x20");
    auto x21 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x21");
    auto x22 = model.AddVariable(0.0, arhiplex::inf, 0.0, variable_type::continuous, "x22");
    auto x23 = model.AddVariable(0.0, arhiplex::inf, 0.0, variable_type::continuous, "x23");
    auto x24 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x24");
    auto x25 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x25");
    auto x26 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x26");
    auto x27 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x27");
    auto x28 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x28");
    auto x29 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x29");
    auto x30 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x30");
    auto x31 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x31");
    auto x32 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x32");
    auto x33 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x33");
    auto x34 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x34");
    auto x35 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x35");
    auto x36 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x36");
    auto x37 = model.AddVariable(0.0, 300.0, 0.0, variable_type::continuous, "x37");
    auto x38 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x38");
    auto x39 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x39");
    auto x40 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x40");
    auto x41 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x41");
    auto x42 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x42");
    auto x43 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x43");
    auto x44 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x44");
    auto x45 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x45");
    auto x46 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x46");
    auto x47 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x47");
    auto x48 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x48");
    auto x49 = model.AddVariable(0.0, 1.0, 0.0, variable_type::continuous, "x49");

    model.AddConstraint(x20 + x21 + x22 + x23 == 300, "e2");
    model.AddConstraint(x24 - x25 - x26 == 0, "e3");
    model.AddConstraint(x27 - x28 - x29 - x30 == 0, "e4");
    model.AddConstraint(x31 - x32 - x33 - x34 == 0, "e5");
    model.AddConstraint(x35 - x36 - x37 == 0, "e6");
    model.AddConstraint(x38 + x39 == 1, "e7");
    model.AddConstraint(x40 + x41 + x42 == 1, "e8");
    model.AddConstraint(x43 + x44 + x45 == 1, "e9");
    model.AddConstraint(x46 + x47 == 1, "e10");
    model.AddConstraint(x16 + x17 + x48 == 1, "e11");
    model.AddConstraint(x18 + x19 + x49 == 1, "e12");
    model.AddConstraint(x2 - 300 * b8 <= 0, "e13");
    model.AddConstraint(x3 - 300 * b9 <= 0, "e14");
    model.AddConstraint(x10 - 0.3333333333 * x20 -x32 * x43 == 0, "e15");
    model.AddConstraint(x11 - 0.3333333333 * x20 - x32 * x44 == 0, "e16");
    model.AddConstraint(x12 - 0.3333333333 * x20 - x32 * x45 == 0, "e17");
    model.AddConstraint(x13 - 0.3333333333 * x21 - x28 * x40 == 0, "e18");
    model.AddConstraint(x14 - 0.3333333333 * x21 - x28 * x41 == 0, "e19");
    model.AddConstraint(x15 - 0.3333333333 * x21 - x28 * x42 == 0, "e20");

    model.AddConstraint(x10 - x24 * x38 - x27 * x40 == 0, "e21");
    model.AddConstraint(x11 - x24 * x39 - x27 * x41 == 0, "e22");
    model.AddConstraint(x12 - x27 * x42 == 0, "e23");
    model.AddConstraint(x13 - x31 * x43 == 0, "e24");
    model.AddConstraint(x14 - x31 * x44 - x35 * x46 == 0, "e25");
    model.AddConstraint(x15 - x31 * x45 - x35 * x47 == 0, "e26");
    model.AddConstraint(0.3333333333 * x22 + x25 * x38 + x29 * x40 + x33 * x43 == 80, "e27");
    model.AddConstraint(0.3333333333 * x22 + x25 * x39 + x29 * x41 + x33 * x44 + x36 * x46 == 30, "e28");
    model.AddConstraint(0.3333333333 * x22 + x29 * x42 + x33 * x45 + x36 * x47 == 20, "e29");
    model.AddConstraint(0.3333333333 * x23 + x26 * x38 + x30 * x40 + x34 * x43 == 20, "e30");
    model.AddConstraint(0.3333333333 * x23 + x26 * x39 + x30 * x41 + x34 * x44 + x37 * x46 == 70, "e31");
    model.AddConstraint(0.3333333333 * x23 + x30 * x42 + x34 * x45 + x37 * x47 == 80, "e32");

    model.AddConstraint(-x10 + x2 * x16, constraint_sense::equal, 0.0, "e33");
    model.AddConstraint(-x11 + x2 * x17 , 0.0, 0.0, "e34");
    model.AddConstraint(-x11 + x2 * x17 == 0, "e34");
    model.AddConstraint(-x12 + x2 * x48 == 0, "e35");
    model.AddConstraint(-x13 + x3 * x18 == 0, "e36");
    model.AddConstraint(-x14 + x3 * x19 == 0, "e37");
    model.AddConstraint(-x15 + x3 * x49 == 0, "e38");
    model.AddConstraint(x4 * x10 - x24 * x38 == 0, "e39");
    model.AddConstraint(x5 * x11 - x27 * x41 == 0, "e40");
    model.AddConstraint(x6 * x14 - x31 * x44 == 0, "e41");
    model.AddConstraint(x7 * x15 - x35 * x47 == 0, "e42");

    auto obj = -0.0139904 * x2 - 0.0661588 * x3 + 0 * x4 + 0 * x5 + 0 * x6 + 0 * x7 + 0.23947 * b8 + 0.75835 * b9 +
        0 * x10 + 0 * x11 + 0 * x12 + 0 * x13 + 0 * x14 + 0 * x15 + 0 * x16 + 0 * x17 + 0 * x18 + 0 * x19 + 0 * x20 +
        0 * x21 + 0 * x22 + 0 * x23 + 0 * x24 + 0 * x25 + 0 * x26 + 0 * x27 + 0 * x28 + 0 * x29 + 0 * x30 + 0 * x31 +
        0 * x32 + 0 * x33 + 0 * x34 + 0 * x35 + 0 * x36 + 0 * x37 + 0 * x38 + 0 * x39 + 0 * x40 + 0 * x41 + 0 * x42 +
        0 * x43 + 0 * x44 + 0 * x45 + 0 * x46 + 0 * x47 + 0 * x48 + 0 * x49 + 0.0187028 * x2 * x4 + 0.0154616 * x2 * x5 -
        0.0011438 * x2 * x16 + 0.0085312 * x2 * x17 + 0.0676294 * x3 * x6 + 0.0746698 * x3 * x7 + 0.0032742 * x3 * x18 +
        0.0577992 * x3 * x19;
    model.SetObjective(obj);

    auto solve_result = model.Solve();

    model.Write("qp.lp");
    

    auto solve_time = solve_result.GetSolveTime();
    auto solve_res = solve_result.GetSolveResult();
    auto solution_status = solve_result.GetSolutionStatus();

    if (solve_res == solve_result::success &&
        (solution_status == solution_status::optimal ||
            solution_status == solution_status::feasible))
    {
        solve_result.WriteSolution("qp.sol");
        auto gap = solve_result.GetRelativeGap();
        auto x17val = solve_result.GetVariableValue(x17);
        auto x39val = solve_result.GetVariableValue("x39");
        auto x10val = solve_result.GetVariableValue("x10");
        auto x42val = solve_result.GetVariableValue(x42);
        auto x20val = solve_result.GetVariableValue("x20");
        auto x27val = solve_result.GetVariableValue("x27");

        std::cout << "Gap: " << gap << "\n";
        std::cout << "Variables:\n" << "x17: " << x17val << " name = " << x17.GetName() <<
            "\nx39: " << x39val << "\nx10: " << x10val <<
            "\nx42: " << x42val << "\nx20: " << x20val <<
            "\nx27: " << x27val << "\n";
    }


  }
  catch (const arhiplex::arhiplex_exception &ex)
  {
    std::cout << ex.what() << std::endl;
  }
  catch (...)
  {
    std::cout << "Unknown exception occurs!";
  }
  return 0;
}
