﻿using arhiplex;
namespace simple_mip
{
    internal class Program
    {
        static void Main(string[] args)
        {

            using (var model = new arhiplex.Model())
            {
                model.SetDblParam("time_limit", 10.0); //10 сек
                model.SetDblParam("mip_rel_gap", 0.0005); //0.05%

                var x1 = model.AddVariable(0, 1, 0.0,
                  Variable_type.binary, "x1");
                var x2 = model.AddVariable(-Model.Inf, Model.Inf, 0.0,
                  Variable_type.continuous, "x2");
                var x3 = model.AddVariable(0.0, Model.Inf, 0.0,
                  Variable_type.continuous, "x3");
                var x4 = model.AddVariable(-Model.Inf, Model.Inf, 0.0,
                  Variable_type.continuous, "x4");

                x3.SetLowerBound(1.1);
                x3.SetUpperBound(10.0);

                model.SetObjective(x1 + 2 * x2 - 0.1 * x3 - 3 * x4,
                  Objective_sense.maximize);

                model.AddConstraint(x1 + x2 <= 5, "c0");
                model.AddConstraint(2 * x1 - x2 >= 0, "c1");
                model.AddConstraint(-x1 + 3 * x2 >= 0, "c2");
                model.AddConstraint(x3 + x4 >= 0.5, "c3");

                var solve_result = model.Solve();

                var solve_time = solve_result.GetSolveTime();
                var solve_res = solve_result.GetSolveResult();
                var solution_status = solve_result.GetSolutionStatus();

                if (solve_res == Solve_result.success &&
                  (solution_status == Solution_status.optimal ||
                   solution_status == Solution_status.feasible))
                {
                    var gap = solve_result.GetRelativeGap();
                    var x1val = solve_result.GetVariableValue(x1);
                    var x2val = solve_result.GetVariableValue("x2");
                    var x3val = solve_result.GetVariableValue("x3");
                    var x4val = solve_result.GetVariableValue(x4);
                    System.Console.WriteLine($"Gap: {gap} \n");
                    System.Console.WriteLine($"Variables:\nx1: {x1val}\nx2: {x2val}\nx3: {x3val}\nx4: {x4val} \n");
                }

            }
        }
    }
}
