#include "arhiplex_client.h"
#include <iostream>


int main(int argc, char *argv[])
{
  try
  {
    setlocale(LC_CTYPE, "Russian");
    using namespace arhiplex;
    arhiplex::Model model;

    model.Read("binkar10_1.mps"); //простая модель https://miplib.zib.de/instance_details_binkar10_1.html
    model.SetDblParam("time_limit", 30.0); //30 сек
    model.SetDblParam("mip_rel_gap", 0.0005); //0.05%

    const char* name_mapping_file = "name_mapping.txt";
    const auto solve_result = model.SolveRemote(name_mapping_file);
    
    const auto solve_time = solve_result.GetSolveTime();
    const auto solve_res = solve_result.GetSolveResult();
    const auto solution_status = solve_result.GetSolutionStatus();

    if (solve_res == solve_result::success && 
      (solution_status == solution_status::optimal ||
       solution_status == solution_status::feasible))
    {
      const auto gap = solve_result.GetRelativeGap();
      const auto obj_value = solve_result.GetObjectiveFunctionValue();
      std::cout << "Gap: "  << gap << std::endl;
      std::cout << "Objective Value: " << obj_value << std::endl;
    }       
    std::cout << "Solve time: " << solve_time << std::endl;
  }
  catch (const arhiplex::arhiplex_exception &ex)
  {
    std::cout << ex.what() << std::endl;
  }
  catch (...)
  {
    std::cout << "Unknown exception occurs!";
  }
  return 0;
}
