﻿#pragma once
#include <stdexcept>

#define CHECKERR(ptr)                                                   \
    if (ptr->GetErrorCode() != 0)                                         \
    {                                                                     \
        throw arhiplex_exception(ptr->GetErrorCode(), ptr->GetErrorText()); \
    }

/*!
arhiplex
*/

namespace arhiplex
{

/*!
* \class arhiplex_exception

\~russian
* Исключение, генерируемое всеми классами в случае ошибки
* \brief arhiplex-исключение

\~english
* Exception thrown by all classes in case of an error
* \brief arhiplex-exception

\~chinese-traditional
* Exception thrown by all classes in case of an error
* \brief arhiplex-exception
*/

class arhiplex_exception : public std::runtime_error
{
  public:
    arhiplex_exception(int err, const char *szMsg) : runtime_error(szMsg), error_code(err)
    {
    }

/**
\~russian
* Код ошибки arhiplex. Как правило, всегда -1

\~english
* Arhiplex error code. Usually always -1

\~chinese-traditional
* Arhiplex error code. Usually always -1
*/

    int get_error_code() const
    {
        return error_code;
    }

  private:
    int error_code;
};

} // namespace arhiplex