import numpy
from typing import ClassVar, Iterable, overload

kArhiplexInf: float

class ArhiplexException(Exception): ...

class Constraint:
    """Работа с линейными ограничениями у модели, 

        позволяет работать с выражением и границами, а также удалять его"""
    def __init__(self, arg0, arg1: constraint_sense, arg2: float) -> None:
        """__init__(self: arhiplexpy.Constraint, arg0: arhiplex::LinearExpression, arg1: arhiplexpy.constraint_sense, arg2: float) -> None"""
    def get_linear_expression(self, *args, **kwargs):
        """get_linear_expression(self: arhiplexpy.Constraint) -> arhiplex::LinearExpression

        Линейная часть выражения, связанного с ограничением

                :return: линейная часть выражения, связанного с ограничением
        """
    def get_lower_bound(self) -> float:
        """get_lower_bound(self: arhiplexpy.Constraint) -> float

        Получает нижнюю границу ограничения

                :return: нижнюю границу ограничения
        """
    def get_name(self) -> str:
        """get_name(self: arhiplexpy.Constraint) -> str

        Получает имя ограничения

                :return: имя ограничения
        """
    def get_quad_expression(self, *args, **kwargs):
        """get_quad_expression(self: arhiplexpy.Constraint) -> arhiplex::QuadExpression

        Квадратичная часть выражения, связанного с ограничением

                :return: квадратичная часть выражения, связанного с ограничением
        """
    def get_range(self) -> float:
        """get_range(self: arhiplexpy.Constraint) -> float

        Получает интервал ограничения: upper_bound - lower_bound

                :return: upper_bound - lower_bound
        """
    def get_upper_bound(self) -> float:
        """get_upper_bound(self: arhiplexpy.Constraint) -> float

        Получает верхнюю границу ограничения

                :return: верхнюю границу ограничения
        """
    def remove(self) -> None:
        """remove(self: arhiplexpy.Constraint) -> None

        Помечает ограничение как удаленное. Такое ограничение будет исключено из расчетов
        """
    def set_lower_bound(self, lower_bound: float) -> None:
        """set_lower_bound(self: arhiplexpy.Constraint, lower_bound: float) -> None

        Задаёт нижнюю границу ограничения

                :param lower_bound: новая нижняя граница ограничения
        """
    def set_name(self, constr_name: str) -> None:
        """set_name(self: arhiplexpy.Constraint, constr_name: str) -> None

        Задаёт имя ограничения

                :param constr_name: имя ограничения
        """
    def set_range(self, range: float) -> None:
        """set_range(self: arhiplexpy.Constraint, range: float) -> None

        Задаёт интервал ограничения: lower_bound <= expression <= lower_bound + range

                :param range: интервал для ограничения
        """
    def set_upper_bound(self, upper_bound: float) -> None:
        """set_upper_bound(self: arhiplexpy.Constraint, upper_bound: float) -> None

        Задает верхнюю границу ограничения

                :param upper_bound: новая верхняя граница ограничения
        """

class GeneralConstraint:
    """Работа с нелинейными ограничениями у модели"""
    def __init__(self, arg0, arg1, arg2: str) -> None:
        """__init__(self: arhiplexpy.GeneralConstraint, arg0: arhiplex::GeneralExpression, arg1: arhiplex::Variable, arg2: str) -> None"""
    def get_expression(self, *args, **kwargs):
        """get_expression(self: arhiplexpy.GeneralConstraint) -> arhiplex::GeneralExpression

        Выражение, связанное с ограничением

                :return: выражение, связанное с ограничением
        """
    def get_name(self) -> str:
        """get_name(self: arhiplexpy.GeneralConstraint) -> str

        Получает имя ограничения

                :return: имя ограничения
        """
    def get_variable(self, *args, **kwargs):
        """get_variable(self: arhiplexpy.GeneralConstraint) -> arhiplex::Variable

        Пеерменная, связанная с ограничением

                :return: переменная, связанная с ограничением
        """
    def remove(self) -> None:
        """remove(self: arhiplexpy.GeneralConstraint) -> None

        Помечает ограничение как удаленное. Такое ограничение будет исключено из расчетов
        """
    def set_name(self, constr_name: str) -> None:
        """set_name(self: arhiplexpy.GeneralConstraint, constr_name: str) -> None

        Задаёт имя ограничения

                :param constr_name: имя ограничения
        """

class GeneralExpression:
    """Выражение общего вида"""
    def __init__(self) -> None:
        """__init__(self: arhiplexpy.GeneralExpression) -> None

        Создает пустое выражение
        """
    def add_expr(self, expr: GeneralExpression) -> None:
        """add_expr(self: arhiplexpy.GeneralExpression, expr: arhiplexpy.GeneralExpression) -> None

        Добавляет выражение, для типов plus и multiply

                :param expr : добавляемое выражение
        """
    def copy(self) -> GeneralExpression:
        """copy(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Создает копию выражения, не привязанную к модели         или другому ограничению

                :return: копия выражения
        """
    def get_arity(self) -> int:
        """get_arity(self: arhiplexpy.GeneralExpression) -> int

        Возвращает арность выражения

                :return: арность выражения
        """
    def get_constant(self) -> float:
        """get_constant(self: arhiplexpy.GeneralExpression) -> float

        Возвращает значение константы для выражения с типом constant

                :return: значение константы
        """
    def get_expr(self, idx: int) -> GeneralExpression:
        """get_expr(self: arhiplexpy.GeneralExpression, idx: int) -> arhiplexpy.GeneralExpression

        Возвращает по индексу содержащееся выражение

                :param idx : индекс получаемого выражения
                :return: выражение
        """
    def get_expr_count(self) -> int:
        """get_expr_count(self: arhiplexpy.GeneralExpression) -> int

        Возвращает количество элементов в выражении

                :return: количество элементов в выражении
        """
    def get_type(self) -> gen_expr_type:
        """get_type(self: arhiplexpy.GeneralExpression) -> arhiplexpy.gen_expr_type

        Возвращает тип выражения

                :return: тип выражения
        """
    def get_variable(self) -> Variable:
        """get_variable(self: arhiplexpy.GeneralExpression) -> arhiplexpy.Variable

        Возвращает переменную для выражения с типом variable

                :return: объект переменной
        """
    def set_expr(self, idx: int, expr: GeneralExpression) -> None:
        """set_expr(self: arhiplexpy.GeneralExpression, idx: int, expr: arhiplexpy.GeneralExpression) -> None

        Задает выражение по индексу

                :param idx : индекс выражения
                :param expr : выражение
        """
    @overload
    def __add__(self, arg0: float) -> GeneralExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __add__(self, arg0: Variable) -> GeneralExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __add__(self, arg0: LinearExpression) -> GeneralExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __add__(self, arg0: QuadExpression) -> GeneralExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __add__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __add__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __add__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    def __eq__(self, arg0: Variable) -> GeneralConstraint:
        """__eq__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralConstraint"""
    @overload
    def __iadd__(self, arg0: float) -> GeneralExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __iadd__(self, arg0: Variable) -> GeneralExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __iadd__(self, arg0: LinearExpression) -> GeneralExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __iadd__(self, arg0: QuadExpression) -> GeneralExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __iadd__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __iadd__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __iadd__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __imul__(self, arg0: float) -> GeneralExpression:
        """__imul__(*args, **kwargs)
        Overloaded function.

        1. __imul__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __imul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __imul__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__imul__(*args, **kwargs)
        Overloaded function.

        1. __imul__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __imul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __isub__(self, arg0: float) -> GeneralExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __isub__(self, arg0: Variable) -> GeneralExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __isub__(self, arg0: LinearExpression) -> GeneralExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __isub__(self, arg0: QuadExpression) -> GeneralExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __isub__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __isub__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        3. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        4. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        6. __isub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __itruediv__(self, arg0: float) -> GeneralExpression:
        """__itruediv__(*args, **kwargs)
        Overloaded function.

        1. __itruediv__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __itruediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __itruediv__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__itruediv__(*args, **kwargs)
        Overloaded function.

        1. __itruediv__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        2. __itruediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __mul__(self, arg0: Variable) -> GeneralExpression:
        """__mul__(*args, **kwargs)
        Overloaded function.

        1. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __mul__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __mul__(self, arg0: LinearExpression) -> GeneralExpression:
        """__mul__(*args, **kwargs)
        Overloaded function.

        1. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __mul__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __mul__(self, arg0: QuadExpression) -> GeneralExpression:
        """__mul__(*args, **kwargs)
        Overloaded function.

        1. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __mul__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __mul__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__mul__(*args, **kwargs)
        Overloaded function.

        1. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __mul__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __mul__(self, arg0: float) -> GeneralExpression:
        """__mul__(*args, **kwargs)
        Overloaded function.

        1. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __mul__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __mul__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """
    def __neg__(self) -> GeneralExpression:
        """__neg__(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression"""
    def __pow__(self, arg0: int) -> float | Variable | LinearExpression | QuadExpression | GeneralExpression:
        """__pow__(self: arhiplexpy.GeneralExpression, arg0: int) -> Union[float, arhiplexpy.Variable, arhiplexpy.LinearExpression, arhiplexpy.QuadExpression, arhiplexpy.GeneralExpression]"""
    def __radd__(self, arg0: float) -> GeneralExpression:
        """__radd__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression"""
    def __rmul__(self, arg0: float) -> GeneralExpression:
        """__rmul__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression"""
    def __rsub__(self, arg0: float) -> GeneralExpression:
        """__rsub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression"""
    @overload
    def __sub__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        2. __sub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        3. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        4. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        6. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __sub__(self, arg0: float) -> GeneralExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        2. __sub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        3. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        4. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        6. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __sub__(self, arg0: Variable) -> GeneralExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        2. __sub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        3. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        4. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        6. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __sub__(self, arg0: QuadExpression) -> GeneralExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        2. __sub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        3. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        4. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        6. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __sub__(self, arg0: LinearExpression) -> GeneralExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        2. __sub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        3. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        4. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        6. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __sub__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        2. __sub__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        3. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        4. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        5. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        6. __sub__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __truediv__(self, arg0: Variable) -> GeneralExpression:
        """__truediv__(*args, **kwargs)
        Overloaded function.

        1. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __truediv__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __truediv__(self, arg0: LinearExpression) -> GeneralExpression:
        """__truediv__(*args, **kwargs)
        Overloaded function.

        1. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __truediv__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __truediv__(self, arg0: QuadExpression) -> GeneralExpression:
        """__truediv__(*args, **kwargs)
        Overloaded function.

        1. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __truediv__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __truediv__(self, arg0: GeneralExpression) -> GeneralExpression:
        """__truediv__(*args, **kwargs)
        Overloaded function.

        1. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __truediv__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """
    @overload
    def __truediv__(self, arg0: float) -> GeneralExpression:
        """__truediv__(*args, **kwargs)
        Overloaded function.

        1. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        2. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        3. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        4. __truediv__(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        5. __truediv__(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression
        """

class LinearExpression:
    """Обеспечивает работу с линейными выражениями -     добавление/удаление элементов и изменение коэффициентов.    Элемент выражения - переменная * коэффициент."""
    @overload
    def __init__(self, value: float = ...) -> None:
        """__init__(*args, **kwargs)
        Overloaded function.

        1. __init__(self: arhiplexpy.LinearExpression, value: float = 0.0) -> None

        Создает пустое выражение с возможностью задать константу

                :param value: константа в выражении

        2. __init__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable, arg1: float) -> None
        """
    @overload
    def __init__(self, arg0: Variable, arg1: float) -> None:
        """__init__(*args, **kwargs)
        Overloaded function.

        1. __init__(self: arhiplexpy.LinearExpression, value: float = 0.0) -> None

        Создает пустое выражение с возможностью задать константу

                :param value: константа в выражении

        2. __init__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable, arg1: float) -> None
        """
    def add_constant(self, value: float) -> None:
        """add_constant(self: arhiplexpy.LinearExpression, value: float) -> None

        Добавляет константу к выражению

                :param: value значение константы
        """
    def add_expression(self, expr: LinearExpression, mult: float) -> None:
        """add_expression(self: arhiplexpy.LinearExpression, expr: arhiplexpy.LinearExpression, mult: float) -> None

        Добавляет выражение к выражению

                :param expr: добавляемое выражение
                :param mult: коэффициент к добавляемому выражению
        """
    def add_term(self, var: Variable, coeff: float = ...) -> None:
        """add_term(self: arhiplexpy.LinearExpression, var: arhiplexpy.Variable, coeff: float = 1.0) -> None

        Добавляет элемент к выражению

                :param var: переменная
                :param coeff: коэффициент к переменной
        """
    def copy(self) -> LinearExpression:
        """copy(self: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression

        Создает копию выражения, не привязанную к модели         или другому ограничению

                :return: копия выражения
        """
    def empty(self) -> bool:
        """empty(self: arhiplexpy.LinearExpression) -> bool

        Возвращает истину, если выражение пустое
                :return: истина, если выражение пустое
        """
    def get_constant(self) -> float:
        """get_constant(self: arhiplexpy.LinearExpression) -> float

        Возвращает константу в выражении

                :return: значение константы
        """
    def get_name(self) -> str:
        """get_name(self: arhiplexpy.LinearExpression) -> str

        Получает имя выражения

                :return: имя выражения
        """
    def get_quad_part(self, *args, **kwargs):
        """get_quad_part(self: arhiplexpy.LinearExpression) -> arhiplex::QuadExpression

        Возвращает квадратичную часть выражения

                :return: квадратичная часть выражения
        """
    def get_term_coeff(self, ind: int) -> float:
        """get_term_coeff(self: arhiplexpy.LinearExpression, ind: int) -> float

        Возвращает коэффициент переменной по индексу элемента в выражении

                :param ind: индекс элемента в выражении
                :return: значение коэффициента переменной
        """
    def get_term_variable(self, ind: int) -> Variable:
        """get_term_variable(self: arhiplexpy.LinearExpression, ind: int) -> arhiplexpy.Variable

        Возвращает переменную по индексу элемента в выражении

                :param ind: индекс элемента в выражении
                :return: объект переменной
        """
    def get_term_variable_idx(self, ind: int) -> int:
        """get_term_variable_idx(self: arhiplexpy.LinearExpression, ind: int) -> int

        Возвращает порядковый индекс переменной в модели по индексу элемента в выражении

                :param ind: индекс элемента в выражении
                :return: индекс переменной
        """
    def get_terms_count(self) -> int:
        """get_terms_count(self: arhiplexpy.LinearExpression) -> int

        Возвращает количество элементов в выражении

                :return: количество элементов в выражении
        """
    def remove_term(self, idx: int) -> None:
        """remove_term(self: arhiplexpy.LinearExpression, idx: int) -> None

        Удаляет элемент выражения по индексу

                :param idx: индекс удаляемого элемента в выражении
        """
    def remove_variable(self, var: Variable) -> None:
        """remove_variable(self: arhiplexpy.LinearExpression, var: arhiplexpy.Variable) -> None

        Удаляет переменную из выражения

                :param var: удаляемая переменная
        """
    def set_constant(self, value: float) -> None:
        """set_constant(self: arhiplexpy.LinearExpression, value: float) -> None

        Задает константу в выражении

                :param value: значение константы
        """
    def set_name(self, expr_name: str) -> None:
        """set_name(self: arhiplexpy.LinearExpression, expr_name: str) -> None

        Задаёт имя выражения

                :param expr_name: имя выражения
        """
    def set_term_coeff(self, ind: int, value: float) -> None:
        """set_term_coeff(self: arhiplexpy.LinearExpression, ind: int, value: float) -> None

        Задает коэффициент переменной по индексу выражения

                :param ind: индекс элемента в выражении
                :param value: значение коэффициента при переменной в элементе
        """
    @overload
    def __add__(self, arg0: float) -> LinearExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __add__(self, arg0: Variable) -> LinearExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __add__(self, arg0) -> LinearExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __add__(self, arg0: LinearExpression) -> LinearExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __add__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __eq__(self, arg0: Variable) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.Constraint

        4. __eq__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __eq__(self, arg0: LinearExpression) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.Constraint

        4. __eq__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __eq__(self, arg0) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.Constraint

        4. __eq__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __eq__(self, arg0: float) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.Constraint

        4. __eq__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0: LinearExpression) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0: Variable) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0: float) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __iadd__(self, arg0: float) -> LinearExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __iadd__(self, arg0: Variable) -> LinearExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __iadd__(self, arg0) -> LinearExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __iadd__(self, arg0: LinearExpression) -> LinearExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __iadd__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    def __imul__(self, arg0: float) -> LinearExpression:
        """__imul__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression"""
    @overload
    def __isub__(self, arg0: float) -> LinearExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __isub__(self, arg0: Variable) -> LinearExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __isub__(self, arg0) -> LinearExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    @overload
    def __isub__(self, arg0: LinearExpression) -> LinearExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        2. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression

        3. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        4. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __isub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression
        """
    def __itruediv__(self, arg0: float) -> LinearExpression:
        """__itruediv__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression"""
    def __le__(self, arg0: float) -> Constraint:
        """__le__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.Constraint"""
    def __mul__(self, arg0: float) -> LinearExpression:
        """__mul__(*args, **kwargs)
        Overloaded function.

        1. __mul__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplex::GeneralExpression

        2. __mul__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplex::QuadExpression

        3. __mul__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        4. __mul__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplex::QuadExpression

        5. __mul__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplex::QuadExpression

        6. __mul__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression
        """
    def __neg__(self) -> LinearExpression:
        """__neg__(self: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression"""
    def __pow__(self, other):
        """__pow__(self: arhiplexpy.LinearExpression, arg0: int) -> Union[float, arhiplexpy.Variable, arhiplexpy.LinearExpression, arhiplex::QuadExpression, arhiplex::GeneralExpression]"""
    def __radd__(self, arg0: float) -> LinearExpression:
        """__radd__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression"""
    def __rmul__(self, arg0: float) -> LinearExpression:
        """__rmul__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression"""
    def __rsub__(self, arg0: float) -> LinearExpression:
        """__rsub__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression"""
    def __rtruediv__(self, other):
        """__rtruediv__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplex::GeneralExpression"""
    @overload
    def __sub__(self, arg0) -> LinearExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        2. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        3. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression

        4. __sub__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        5. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression
        """
    @overload
    def __sub__(self, arg0: LinearExpression) -> LinearExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        2. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        3. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression

        4. __sub__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        5. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression
        """
    @overload
    def __sub__(self, arg0: float) -> LinearExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        2. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        3. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression

        4. __sub__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        5. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression
        """
    @overload
    def __sub__(self, arg0: Variable) -> LinearExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplexpy.LinearExpression

        2. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        3. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.LinearExpression

        4. __sub__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression

        5. __sub__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.LinearExpression
        """
    def __truediv__(self, arg0: float) -> LinearExpression:
        """__truediv__(*args, **kwargs)
        Overloaded function.

        1. __truediv__(self: arhiplexpy.LinearExpression, arg0: arhiplex::QuadExpression) -> arhiplex::GeneralExpression

        2. __truediv__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplex::GeneralExpression

        3. __truediv__(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplex::GeneralExpression

        4. __truediv__(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.LinearExpression
        """

class MathFunc:
    """Математические функции для нелинейных функций"""
    def __init__(self) -> None:
        """__init__(self: arhiplexpy.MathFunc) -> None"""
    @overload
    def cos(self) -> GeneralExpression:
        """cos(*args, **kwargs)
        Overloaded function.

        1. cos(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        2. cos(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        3. cos(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        4. cos(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        5. cos(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos
        """
    @overload
    def cos(self) -> GeneralExpression:
        """cos(*args, **kwargs)
        Overloaded function.

        1. cos(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        2. cos(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        3. cos(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        4. cos(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        5. cos(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos
        """
    @overload
    def cos(self) -> GeneralExpression:
        """cos(*args, **kwargs)
        Overloaded function.

        1. cos(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        2. cos(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        3. cos(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        4. cos(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        5. cos(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos
        """
    @overload
    def cos(self) -> GeneralExpression:
        """cos(*args, **kwargs)
        Overloaded function.

        1. cos(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        2. cos(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        3. cos(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        4. cos(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        5. cos(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos
        """
    @overload
    def cos(self) -> GeneralExpression:
        """cos(*args, **kwargs)
        Overloaded function.

        1. cos(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        2. cos(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        3. cos(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        4. cos(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos

        5. cos(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейcos

        :return: выражение с функциейcos
        """
    @overload
    def exp(self) -> GeneralExpression:
        """exp(*args, **kwargs)
        Overloaded function.

        1. exp(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        2. exp(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        3. exp(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        4. exp(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        5. exp(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp
        """
    @overload
    def exp(self) -> GeneralExpression:
        """exp(*args, **kwargs)
        Overloaded function.

        1. exp(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        2. exp(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        3. exp(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        4. exp(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        5. exp(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp
        """
    @overload
    def exp(self) -> GeneralExpression:
        """exp(*args, **kwargs)
        Overloaded function.

        1. exp(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        2. exp(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        3. exp(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        4. exp(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        5. exp(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp
        """
    @overload
    def exp(self) -> GeneralExpression:
        """exp(*args, **kwargs)
        Overloaded function.

        1. exp(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        2. exp(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        3. exp(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        4. exp(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        5. exp(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp
        """
    @overload
    def exp(self) -> GeneralExpression:
        """exp(*args, **kwargs)
        Overloaded function.

        1. exp(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        2. exp(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        3. exp(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        4. exp(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp

        5. exp(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейexp

        :return: выражение с функциейexp
        """
    @overload
    def log(self) -> GeneralExpression:
        """log(*args, **kwargs)
        Overloaded function.

        1. log(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        2. log(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        3. log(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        4. log(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        5. log(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog
        """
    @overload
    def log(self) -> GeneralExpression:
        """log(*args, **kwargs)
        Overloaded function.

        1. log(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        2. log(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        3. log(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        4. log(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        5. log(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog
        """
    @overload
    def log(self) -> GeneralExpression:
        """log(*args, **kwargs)
        Overloaded function.

        1. log(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        2. log(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        3. log(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        4. log(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        5. log(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog
        """
    @overload
    def log(self) -> GeneralExpression:
        """log(*args, **kwargs)
        Overloaded function.

        1. log(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        2. log(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        3. log(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        4. log(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        5. log(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog
        """
    @overload
    def log(self) -> GeneralExpression:
        """log(*args, **kwargs)
        Overloaded function.

        1. log(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        2. log(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        3. log(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        4. log(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog

        5. log(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog

        :return: выражение с функциейlog
        """
    @overload
    def log10(self) -> GeneralExpression:
        """log10(*args, **kwargs)
        Overloaded function.

        1. log10(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        2. log10(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        3. log10(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        4. log10(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        5. log10(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10
        """
    @overload
    def log10(self) -> GeneralExpression:
        """log10(*args, **kwargs)
        Overloaded function.

        1. log10(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        2. log10(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        3. log10(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        4. log10(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        5. log10(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10
        """
    @overload
    def log10(self) -> GeneralExpression:
        """log10(*args, **kwargs)
        Overloaded function.

        1. log10(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        2. log10(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        3. log10(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        4. log10(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        5. log10(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10
        """
    @overload
    def log10(self) -> GeneralExpression:
        """log10(*args, **kwargs)
        Overloaded function.

        1. log10(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        2. log10(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        3. log10(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        4. log10(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        5. log10(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10
        """
    @overload
    def log10(self) -> GeneralExpression:
        """log10(*args, **kwargs)
        Overloaded function.

        1. log10(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        2. log10(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        3. log10(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        4. log10(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10

        5. log10(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog10

        :return: выражение с функциейlog10
        """
    @overload
    def log2(self) -> GeneralExpression:
        """log2(*args, **kwargs)
        Overloaded function.

        1. log2(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        2. log2(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        3. log2(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        4. log2(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        5. log2(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2
        """
    @overload
    def log2(self) -> GeneralExpression:
        """log2(*args, **kwargs)
        Overloaded function.

        1. log2(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        2. log2(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        3. log2(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        4. log2(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        5. log2(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2
        """
    @overload
    def log2(self) -> GeneralExpression:
        """log2(*args, **kwargs)
        Overloaded function.

        1. log2(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        2. log2(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        3. log2(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        4. log2(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        5. log2(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2
        """
    @overload
    def log2(self) -> GeneralExpression:
        """log2(*args, **kwargs)
        Overloaded function.

        1. log2(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        2. log2(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        3. log2(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        4. log2(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        5. log2(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2
        """
    @overload
    def log2(self) -> GeneralExpression:
        """log2(*args, **kwargs)
        Overloaded function.

        1. log2(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        2. log2(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        3. log2(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        4. log2(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2

        5. log2(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlog2

        :return: выражение с функциейlog2
        """
    @overload
    def logistic(self) -> GeneralExpression:
        """logistic(*args, **kwargs)
        Overloaded function.

        1. logistic(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        2. logistic(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        3. logistic(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        4. logistic(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        5. logistic(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic
        """
    @overload
    def logistic(self) -> GeneralExpression:
        """logistic(*args, **kwargs)
        Overloaded function.

        1. logistic(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        2. logistic(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        3. logistic(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        4. logistic(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        5. logistic(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic
        """
    @overload
    def logistic(self) -> GeneralExpression:
        """logistic(*args, **kwargs)
        Overloaded function.

        1. logistic(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        2. logistic(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        3. logistic(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        4. logistic(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        5. logistic(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic
        """
    @overload
    def logistic(self) -> GeneralExpression:
        """logistic(*args, **kwargs)
        Overloaded function.

        1. logistic(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        2. logistic(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        3. logistic(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        4. logistic(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        5. logistic(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic
        """
    @overload
    def logistic(self) -> GeneralExpression:
        """logistic(*args, **kwargs)
        Overloaded function.

        1. logistic(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        2. logistic(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        3. logistic(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        4. logistic(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic

        5. logistic(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейlogistic

        :return: выражение с функциейlogistic
        """
    @overload
    def pow(self, arg0: float) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: Variable) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: LinearExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: QuadExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: GeneralExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: float) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: Variable) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: LinearExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: QuadExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: GeneralExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: float) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: Variable) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: LinearExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: QuadExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: GeneralExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: float) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: Variable) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: LinearExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: QuadExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: GeneralExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: float) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: Variable) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: LinearExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: QuadExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def pow(self, arg0: GeneralExpression) -> GeneralExpression:
        """pow(*args, **kwargs)
        Overloaded function.

        1. pow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        2. pow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        3. pow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        4. pow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        5. pow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        6. pow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        7. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        8. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        9. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        10. pow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        11. pow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        12. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        13. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        14. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        15. pow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        16. pow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        17. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        18. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        19. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        20. pow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        21. pow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        22. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        23. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        24. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow

        25. pow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейpow

        :return: выражение с функциейpow
        """
    @overload
    def signpow(self, arg0: float) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: Variable) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: LinearExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: QuadExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: GeneralExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: float) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: Variable) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: LinearExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: QuadExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: GeneralExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: float) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: Variable) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: LinearExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: QuadExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: GeneralExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: float) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: Variable) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: LinearExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: QuadExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: GeneralExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: float) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: Variable) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: LinearExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: QuadExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def signpow(self, arg0: GeneralExpression) -> GeneralExpression:
        """signpow(*args, **kwargs)
        Overloaded function.

        1. signpow(self: float, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        2. signpow(self: float, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        3. signpow(self: float, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        4. signpow(self: float, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        5. signpow(self: float, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        6. signpow(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        7. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        8. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        9. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        10. signpow(self: arhiplexpy.Variable, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        11. signpow(self: arhiplexpy.LinearExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        12. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        13. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        14. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        15. signpow(self: arhiplexpy.LinearExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        16. signpow(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        17. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        18. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        19. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        20. signpow(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        21. signpow(self: arhiplexpy.GeneralExpression, arg0: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        22. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        23. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        24. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow

        25. signpow(self: arhiplexpy.GeneralExpression, arg0: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsignpow

        :return: выражение с функциейsignpow
        """
    @overload
    def sin(self) -> GeneralExpression:
        """sin(*args, **kwargs)
        Overloaded function.

        1. sin(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        2. sin(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        3. sin(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        4. sin(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        5. sin(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin
        """
    @overload
    def sin(self) -> GeneralExpression:
        """sin(*args, **kwargs)
        Overloaded function.

        1. sin(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        2. sin(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        3. sin(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        4. sin(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        5. sin(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin
        """
    @overload
    def sin(self) -> GeneralExpression:
        """sin(*args, **kwargs)
        Overloaded function.

        1. sin(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        2. sin(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        3. sin(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        4. sin(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        5. sin(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin
        """
    @overload
    def sin(self) -> GeneralExpression:
        """sin(*args, **kwargs)
        Overloaded function.

        1. sin(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        2. sin(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        3. sin(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        4. sin(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        5. sin(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin
        """
    @overload
    def sin(self) -> GeneralExpression:
        """sin(*args, **kwargs)
        Overloaded function.

        1. sin(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        2. sin(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        3. sin(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        4. sin(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin

        5. sin(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsin

        :return: выражение с функциейsin
        """
    @overload
    def sqr(self) -> GeneralExpression:
        """sqr(*args, **kwargs)
        Overloaded function.

        1. sqr(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        2. sqr(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        3. sqr(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        4. sqr(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        5. sqr(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr
        """
    @overload
    def sqr(self) -> GeneralExpression:
        """sqr(*args, **kwargs)
        Overloaded function.

        1. sqr(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        2. sqr(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        3. sqr(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        4. sqr(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        5. sqr(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr
        """
    @overload
    def sqr(self) -> GeneralExpression:
        """sqr(*args, **kwargs)
        Overloaded function.

        1. sqr(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        2. sqr(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        3. sqr(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        4. sqr(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        5. sqr(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr
        """
    @overload
    def sqr(self) -> GeneralExpression:
        """sqr(*args, **kwargs)
        Overloaded function.

        1. sqr(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        2. sqr(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        3. sqr(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        4. sqr(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        5. sqr(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr
        """
    @overload
    def sqr(self) -> GeneralExpression:
        """sqr(*args, **kwargs)
        Overloaded function.

        1. sqr(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        2. sqr(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        3. sqr(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        4. sqr(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr

        5. sqr(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqr

        :return: выражение с функциейsqr
        """
    @overload
    def sqrt(self) -> GeneralExpression:
        """sqrt(*args, **kwargs)
        Overloaded function.

        1. sqrt(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        2. sqrt(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        3. sqrt(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        4. sqrt(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        5. sqrt(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt
        """
    @overload
    def sqrt(self) -> GeneralExpression:
        """sqrt(*args, **kwargs)
        Overloaded function.

        1. sqrt(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        2. sqrt(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        3. sqrt(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        4. sqrt(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        5. sqrt(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt
        """
    @overload
    def sqrt(self) -> GeneralExpression:
        """sqrt(*args, **kwargs)
        Overloaded function.

        1. sqrt(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        2. sqrt(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        3. sqrt(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        4. sqrt(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        5. sqrt(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt
        """
    @overload
    def sqrt(self) -> GeneralExpression:
        """sqrt(*args, **kwargs)
        Overloaded function.

        1. sqrt(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        2. sqrt(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        3. sqrt(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        4. sqrt(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        5. sqrt(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt
        """
    @overload
    def sqrt(self) -> GeneralExpression:
        """sqrt(*args, **kwargs)
        Overloaded function.

        1. sqrt(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        2. sqrt(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        3. sqrt(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        4. sqrt(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt

        5. sqrt(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейsqrt

        :return: выражение с функциейsqrt
        """
    @overload
    def tan(self) -> GeneralExpression:
        """tan(*args, **kwargs)
        Overloaded function.

        1. tan(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        2. tan(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        3. tan(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        4. tan(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        5. tan(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan
        """
    @overload
    def tan(self) -> GeneralExpression:
        """tan(*args, **kwargs)
        Overloaded function.

        1. tan(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        2. tan(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        3. tan(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        4. tan(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        5. tan(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan
        """
    @overload
    def tan(self) -> GeneralExpression:
        """tan(*args, **kwargs)
        Overloaded function.

        1. tan(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        2. tan(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        3. tan(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        4. tan(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        5. tan(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan
        """
    @overload
    def tan(self) -> GeneralExpression:
        """tan(*args, **kwargs)
        Overloaded function.

        1. tan(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        2. tan(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        3. tan(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        4. tan(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        5. tan(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan
        """
    @overload
    def tan(self) -> GeneralExpression:
        """tan(*args, **kwargs)
        Overloaded function.

        1. tan(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        2. tan(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        3. tan(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        4. tan(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan

        5. tan(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtan

        :return: выражение с функциейtan
        """
    @overload
    def tanh(self) -> GeneralExpression:
        """tanh(*args, **kwargs)
        Overloaded function.

        1. tanh(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        2. tanh(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        3. tanh(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        4. tanh(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        5. tanh(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh
        """
    @overload
    def tanh(self) -> GeneralExpression:
        """tanh(*args, **kwargs)
        Overloaded function.

        1. tanh(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        2. tanh(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        3. tanh(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        4. tanh(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        5. tanh(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh
        """
    @overload
    def tanh(self) -> GeneralExpression:
        """tanh(*args, **kwargs)
        Overloaded function.

        1. tanh(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        2. tanh(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        3. tanh(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        4. tanh(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        5. tanh(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh
        """
    @overload
    def tanh(self) -> GeneralExpression:
        """tanh(*args, **kwargs)
        Overloaded function.

        1. tanh(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        2. tanh(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        3. tanh(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        4. tanh(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        5. tanh(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh
        """
    @overload
    def tanh(self) -> GeneralExpression:
        """tanh(*args, **kwargs)
        Overloaded function.

        1. tanh(self: float) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        2. tanh(self: arhiplexpy.Variable) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        3. tanh(self: arhiplexpy.LinearExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        4. tanh(self: arhiplexpy.QuadExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh

        5. tanh(self: arhiplexpy.GeneralExpression) -> arhiplexpy.GeneralExpression

        Получает выражение с функциейtanh

        :return: выражение с функциейtanh
        """

class MatrixModel:
    """Создает экземпляр матричной модели"""
    @overload
    def __init__(self) -> None:
        """__init__(*args, **kwargs)
        Overloaded function.

        1. __init__(self: arhiplexpy.MatrixModel) -> None

        2. __init__(self: arhiplexpy.MatrixModel, arg0: str) -> None
        """
    @overload
    def __init__(self, arg0: str) -> None:
        """__init__(*args, **kwargs)
        Overloaded function.

        1. __init__(self: arhiplexpy.MatrixModel) -> None

        2. __init__(self: arhiplexpy.MatrixModel, arg0: str) -> None
        """
    def add_constraint(self, P: object = ..., q: object = ..., sense: constraint_sense, r: float) -> None:
        """add_constraint(self: arhiplexpy.MatrixModel, P: object = None, q: object = None, sense: arhiplexpy.constraint_sense, r: float) -> None

        Добавляет ограничение в модель с заданными параметрами

                    :param P: матрица квадратичных коэффициентов
                    :param q: вектор коэффициентов переменных
                    :param sense: тип ограничения ( <=, >= , == )
                    :param r: константное значение в правой части ограничения

        """
    def add_constraints(self, A: object, senses: object, b: object) -> None:
        """add_constraints(self: arhiplexpy.MatrixModel, A: object, senses: object, b: object) -> None

        Добавляет ограничения в модель с заданными параметрами

                    :param A: матрица ограничений в формате csr (sparse row matrix)
                    :param senses: массив типов ограничений (constraint_sense)
                    :param b: массив константных значений в правых частях ограничений

        """
    def add_variables(self, lower_bounds: object = ..., upper_bounds: object = ..., obj_values: object = ..., var_types: object = ..., count: int) -> None:
        """add_variables(self: arhiplexpy.MatrixModel, lower_bounds: object = 0.0, upper_bounds: object = inf, obj_values: object = 0.0, var_types: object = <variable_type.continuous: 0>, count: int) -> None

        Добавляет переменные в модель с заданными параметрами

                    :param lower_bounds: нижние границы переменных
                    :param upper_bounds: верхние границы переменных
                    :param obj_values: коэффициенты к переменным в целевой функции
                    :param var_types: типы переменных
                    :param count: количество переменных
        """
    def clear(self) -> None:
        """clear(self: arhiplexpy.MatrixModel) -> None

        Очищает модель от всех данных. Все старые переменные и ограничения становятся невалидными
        """
    def get_bool_param(self, param_name: str) -> bool:
        """get_bool_param(self: arhiplexpy.MatrixModel, param_name: str) -> bool

        Получает логический параметр

                     :param param_name: имя параметра
                     :return: значение параметра
        """
    def get_dbl_param(self, param_name: str) -> float:
        """get_dbl_param(self: arhiplexpy.MatrixModel, param_name: str) -> float

        Получает параметр с плавающей точкой

                     :param param_name: имя параметра
                     :return: значение параметра
        """
    def get_int_param(self, param_name: str) -> int:
        """get_int_param(self: arhiplexpy.MatrixModel, param_name: str) -> int

        Получает целочисленный параметр

                     :param param_name: имя параметра
                     :return: значение параметра
        """
    def get_string_param(self, param_name: str) -> str:
        """get_string_param(self: arhiplexpy.MatrixModel, param_name: str) -> str

        Получает строковый параметр

                     :param param_name: имя параметра
                     :return: значение параметра
        """
    def get_variables_count(self) -> int:
        """get_variables_count(self: arhiplexpy.MatrixModel) -> int

        Получает количество переменных в модели

                    :return: количество переменных в модели
        """
    def set_bool_param(self, param_name: str, param_value: bool) -> None:
        """set_bool_param(self: arhiplexpy.MatrixModel, param_name: str, param_value: bool) -> None

        Задаёт логический параметр

                     :param param_name: имя параметра
                     :param param_value: значение параметра
        """
    def set_dbl_param(self, param_name: str, param_value: float) -> None:
        """set_dbl_param(self: arhiplexpy.MatrixModel, param_name: str, param_value: float) -> None

        Задаёт параметр с плавающей точкой

                     :param param_name: имя параметра
                     :param param_value: значение параметра
        """
    def set_int_param(self, param_name: str, param_value: int) -> None:
        """set_int_param(self: arhiplexpy.MatrixModel, param_name: str, param_value: int) -> None

        Задаёт целочисленный параметр

                     :param param_name: имя параметра
                     :param param_value: значение параметра
        """
    def set_log_file(self, log_file: str) -> None:
        """set_log_file(self: arhiplexpy.MatrixModel, log_file: str) -> None

        Задать файл для записи лога решения

                     :param log_file файл лога
        """
    def set_objective(self, P: object = ..., q: object = ..., sense: objective_sense = ...) -> None:
        """set_objective(self: arhiplexpy.MatrixModel, P: object = None, q: object = None, sense: arhiplexpy.objective_sense = <objective_sense.minimize: 0>) -> None

        Задаёт выражение целевой функции и тип оптимизации

                    :param P: квадратичная часть выражения
                    :param q: вектор коэффициентов к переменным
                    :param sense: тип оптимизации
        """
    def set_objective_offset(self, offset: float) -> None:
        """set_objective_offset(self: arhiplexpy.MatrixModel, offset: float) -> None

        Задаёт константу в выражении целевой функции

                    :param offset: значение константы
        """
    def set_string_param(self, param_name: str, param_value: str) -> None:
        """set_string_param(self: arhiplexpy.MatrixModel, param_name: str, param_value: str) -> None

        Задаёт строковый параметр

                     :param param_name: имя параметра
                     :param param_value: значение параметра
        """
    def solve(self, *args, **kwargs):
        """solve(self: arhiplexpy.MatrixModel) -> arhiplex::MatrixSolveResult

        Стартует оптимизацию модели

                    :return: объект с результатом оптимизации
        """
    def solve_remote(self, *args, **kwargs):
        """solve_remote(self: arhiplexpy.MatrixModel) -> arhiplex::MatrixSolveResult

        Стартует оптимизацию модели на удаленном сервере в синхронном режиме.             Предварительно необходимо установить переменную окружения X_API_KEY.

                    :return: объект с результатом оптимизации
        """
    def write(self, file_name: str) -> None:
        """write(self: arhiplexpy.MatrixModel, file_name: str) -> None

        Записывает модель в файл. Тип будет определен по расширению

                    :param file_name: путь к записываемому файлу

        """
    def write_lp(self, file_name: str) -> None:
        """write_lp(self: arhiplexpy.MatrixModel, file_name: str) -> None

        Записывает модель в файл в формате LP

                    :param file_name: путь к записываемому файлу

        """
    def write_mps(self, file_name: str) -> None:
        """write_mps(self: arhiplexpy.MatrixModel, file_name: str) -> None

        Записывает модель в файл в формате MPS

                    :param file_name: путь к записываемому файлу

        """

class MatrixSolveResult:
    """Результат расчета матричной модели"""
    def __init__(self, calc_uid: str, name_mapping_file: str) -> None:
        """__init__(self: arhiplexpy.MatrixSolveResult, calc_uid: str, name_mapping_file: str) -> None"""
    def get_best_bound(self) -> float:
        """get_best_bound(self: arhiplexpy.MatrixSolveResult) -> float

        Получает значение граничной (двойственной) функции

                          :return: значение граничной (двойственной) функции
        """
    def get_dual_values_vector(self) -> numpy.ndarray[numpy.float64]:
        """get_dual_values_vector(self: arhiplexpy.MatrixSolveResult) -> numpy.ndarray[numpy.float64]

        Получает dual values вектор

                        :return: вектор dual values
        """
    def get_iterations_count(self) -> int:
        """get_iterations_count(self: arhiplexpy.MatrixSolveResult) -> int

        Получает количество итераций, проведенных в процессе расчета

                         :return: количество итераций
        """
    def get_nodes_count(self) -> int:
        """get_nodes_count(self: arhiplexpy.MatrixSolveResult) -> int

        Получает количество обработанных узлов дерева решений

                          :return: количество обработанных узлов
        """
    def get_objective_value(self) -> float:
        """get_objective_value(self: arhiplexpy.MatrixSolveResult) -> float

        Получает значение целевой функции

                        :return: значение целевой функции
        """
    def get_reduced_costs_vector(self) -> numpy.ndarray[numpy.float64]:
        """get_reduced_costs_vector(self: arhiplexpy.MatrixSolveResult) -> numpy.ndarray[numpy.float64]

        Получает reduced costs вектор

                        :return: вектор reduced costs 
        """
    def get_relative_gap(self) -> float:
        """get_relative_gap(self: arhiplexpy.MatrixSolveResult) -> float

        Получает точность решения в процентах

                        :return: точность решения в процентах
        """
    def get_solution_status(self) -> solution_status:
        """get_solution_status(self: arhiplexpy.MatrixSolveResult) -> arhiplexpy.solution_status

        Получает статус модели в итоге расчета

                            :return: значение статуса
        """
    def get_solution_vector(self) -> numpy.ndarray[numpy.float64]:
        """get_solution_vector(self: arhiplexpy.MatrixSolveResult) -> numpy.ndarray[numpy.float64]

        Получает вектор значений переменных

                        :return: вектор переменных
        """
    def get_solve_result(self) -> solve_result:
        """get_solve_result(self: arhiplexpy.MatrixSolveResult) -> arhiplexpy.solve_result

        Получает статус процесса расчетов

                        :return: значение статуса
        """
    def get_solve_time(self) -> float:
        """get_solve_time(self: arhiplexpy.MatrixSolveResult) -> float

        Получает общее время решения

                        :return: общее время решения [сек]
        """
    def write_solution(self, file_name: str) -> None:
        """write_solution(self: arhiplexpy.MatrixSolveResult, file_name: str) -> None

        Записывает решение в файл

                        :param file_name: путь к файлу решения для записи
        """

class Model:
    """Создает экземпляр модели"""
    @overload
    def __init__(self) -> None:
        """__init__(*args, **kwargs)
        Overloaded function.

        1. __init__(self: arhiplexpy.Model) -> None

        2. __init__(self: arhiplexpy.Model, arg0: str) -> None
        """
    @overload
    def __init__(self, arg0: str) -> None:
        """__init__(*args, **kwargs)
        Overloaded function.

        1. __init__(self: arhiplexpy.Model) -> None

        2. __init__(self: arhiplexpy.Model, arg0: str) -> None
        """
    @overload
    def add_constraint(self, expr: LinearExpression, sense: constraint_sense, rhs: float, constr_name: str) -> Constraint:
        """add_constraint(*args, **kwargs)
        Overloaded function.

        1. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        2. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        3. add_constraint(self: arhiplexpy.Model, lhs: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: arhiplexpy.LinearExpression, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param lhs: выражение для ограничения (левая часть)
                :param sense: переменная знака ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        4. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        5. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        6. add_constraint(self: arhiplexpy.Model, constr: arhiplexpy.Constraint, constr_name: str) -> arhiplexpy.Constraint

        Добавляет уже существующее ограничение в модель

                :param constr: выражение для ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения
        """
    @overload
    def add_constraint(self, expr: QuadExpression, sense: constraint_sense, rhs: float, constr_name: str) -> Constraint:
        """add_constraint(*args, **kwargs)
        Overloaded function.

        1. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        2. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        3. add_constraint(self: arhiplexpy.Model, lhs: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: arhiplexpy.LinearExpression, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param lhs: выражение для ограничения (левая часть)
                :param sense: переменная знака ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        4. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        5. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        6. add_constraint(self: arhiplexpy.Model, constr: arhiplexpy.Constraint, constr_name: str) -> arhiplexpy.Constraint

        Добавляет уже существующее ограничение в модель

                :param constr: выражение для ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения
        """
    @overload
    def add_constraint(self, lhs: LinearExpression, sense: constraint_sense, rhs: LinearExpression, constr_name: str) -> Constraint:
        """add_constraint(*args, **kwargs)
        Overloaded function.

        1. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        2. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        3. add_constraint(self: arhiplexpy.Model, lhs: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: arhiplexpy.LinearExpression, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param lhs: выражение для ограничения (левая часть)
                :param sense: переменная знака ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        4. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        5. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        6. add_constraint(self: arhiplexpy.Model, constr: arhiplexpy.Constraint, constr_name: str) -> arhiplexpy.Constraint

        Добавляет уже существующее ограничение в модель

                :param constr: выражение для ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения
        """
    @overload
    def add_constraint(self, expr: LinearExpression, lower_bound: float, upper_bound: float, constr_name: str) -> Constraint:
        """add_constraint(*args, **kwargs)
        Overloaded function.

        1. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        2. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        3. add_constraint(self: arhiplexpy.Model, lhs: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: arhiplexpy.LinearExpression, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param lhs: выражение для ограничения (левая часть)
                :param sense: переменная знака ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        4. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        5. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        6. add_constraint(self: arhiplexpy.Model, constr: arhiplexpy.Constraint, constr_name: str) -> arhiplexpy.Constraint

        Добавляет уже существующее ограничение в модель

                :param constr: выражение для ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения
        """
    @overload
    def add_constraint(self, expr: QuadExpression, lower_bound: float, upper_bound: float, constr_name: str) -> Constraint:
        """add_constraint(*args, **kwargs)
        Overloaded function.

        1. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        2. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        3. add_constraint(self: arhiplexpy.Model, lhs: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: arhiplexpy.LinearExpression, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param lhs: выражение для ограничения (левая часть)
                :param sense: переменная знака ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        4. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        5. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        6. add_constraint(self: arhiplexpy.Model, constr: arhiplexpy.Constraint, constr_name: str) -> arhiplexpy.Constraint

        Добавляет уже существующее ограничение в модель

                :param constr: выражение для ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения
        """
    @overload
    def add_constraint(self, constr: Constraint, constr_name: str) -> Constraint:
        """add_constraint(*args, **kwargs)
        Overloaded function.

        1. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        2. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, sense: arhiplexpy.constraint_sense, rhs: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param expr: выражение для ограничения
                :param sense: тип ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        3. add_constraint(self: arhiplexpy.Model, lhs: arhiplexpy.LinearExpression, sense: arhiplexpy.constraint_sense, rhs: arhiplexpy.LinearExpression, constr_name: str) -> arhiplexpy.Constraint

        Добавляет ограничение в модель с заданными параметрами

                :param lhs: выражение для ограничения (левая часть)
                :param sense: переменная знака ограничения ( <=, >= , == )
                :param rhs: константное значение в правой части ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        4. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        5. add_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, lower_bound: float, upper_bound: float, constr_name: str) -> arhiplexpy.Constraint

        Добавляет интервальное ограничение в модель с         заданными параметрами, вида lhs <= expr <= rhs

                :param expr: выражение для ограничения
                :param lower_bound: нижняя граница ограничения
                :param upper_bound: верхняя граница ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения

        6. add_constraint(self: arhiplexpy.Model, constr: arhiplexpy.Constraint, constr_name: str) -> arhiplexpy.Constraint

        Добавляет уже существующее ограничение в модель

                :param constr: выражение для ограничения
                :param constr_name: имя ограничения
                :return: объект нового ограничения
        """
    def add_constraints(self, constraints: dict) -> None:
        """add_constraints(self: arhiplexpy.Model, constraints: dict) -> None

        Добавляет ограничения в модель

                :param constraints: объект dictionary(name -> constraint)
        """
    @overload
    def add_general_constraint(self, expr: GeneralExpression, var: Variable, name: str) -> GeneralConstraint:
        """add_general_constraint(*args, **kwargs)
        Overloaded function.

        1. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.GeneralExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет общее ограничение

                :param expr: общее выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        2. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет ограничение

                :param expr: квадратичное выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        3. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет ограничение

                :param expr: линейное выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        4. add_general_constraint(self: arhiplexpy.Model, gen_constr: arhiplexpy.GeneralConstraint) -> None

        Добавляет общее ограничение

                :param gen_constr: общее ограничение
                :return: объект ограничения
        """
    @overload
    def add_general_constraint(self, expr: QuadExpression, var: Variable, name: str) -> GeneralConstraint:
        """add_general_constraint(*args, **kwargs)
        Overloaded function.

        1. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.GeneralExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет общее ограничение

                :param expr: общее выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        2. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет ограничение

                :param expr: квадратичное выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        3. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет ограничение

                :param expr: линейное выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        4. add_general_constraint(self: arhiplexpy.Model, gen_constr: arhiplexpy.GeneralConstraint) -> None

        Добавляет общее ограничение

                :param gen_constr: общее ограничение
                :return: объект ограничения
        """
    @overload
    def add_general_constraint(self, expr: LinearExpression, var: Variable, name: str) -> GeneralConstraint:
        """add_general_constraint(*args, **kwargs)
        Overloaded function.

        1. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.GeneralExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет общее ограничение

                :param expr: общее выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        2. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет ограничение

                :param expr: квадратичное выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        3. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет ограничение

                :param expr: линейное выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        4. add_general_constraint(self: arhiplexpy.Model, gen_constr: arhiplexpy.GeneralConstraint) -> None

        Добавляет общее ограничение

                :param gen_constr: общее ограничение
                :return: объект ограничения
        """
    @overload
    def add_general_constraint(self, gen_constr: GeneralConstraint) -> None:
        """add_general_constraint(*args, **kwargs)
        Overloaded function.

        1. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.GeneralExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет общее ограничение

                :param expr: общее выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        2. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет ограничение

                :param expr: квадратичное выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        3. add_general_constraint(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, var: arhiplexpy.Variable, name: str) -> arhiplexpy.GeneralConstraint

        Добавляет ограничение

                :param expr: линейное выражение
                :param var: переменная
                :param name: имя ограничения
                :return: объект ограничения

        4. add_general_constraint(self: arhiplexpy.Model, gen_constr: arhiplexpy.GeneralConstraint) -> None

        Добавляет общее ограничение

                :param gen_constr: общее ограничение
                :return: объект ограничения
        """
    @overload
    def add_mip_start_values(self, start_values: dict) -> None:
        '''add_mip_start_values(*args, **kwargs)
        Overloaded function.

        1. add_mip_start_values(self: arhiplexpy.Model, start_values: dict) -> None

        Задать начальные значения переменных в решении в качестве "подсказки".         Начальные значения очищаются после начала процесса решения.

                :param start_values: объект словаря (имя : значение)

        2. add_mip_start_values(self: arhiplexpy.Model, sol_file: str) -> None

        Задать начальные значения переменных в решении, указав файл решения

                :param sol_file: путь к файлу решения
        '''
    @overload
    def add_mip_start_values(self, sol_file: str) -> None:
        '''add_mip_start_values(*args, **kwargs)
        Overloaded function.

        1. add_mip_start_values(self: arhiplexpy.Model, start_values: dict) -> None

        Задать начальные значения переменных в решении в качестве "подсказки".         Начальные значения очищаются после начала процесса решения.

                :param start_values: объект словаря (имя : значение)

        2. add_mip_start_values(self: arhiplexpy.Model, sol_file: str) -> None

        Задать начальные значения переменных в решении, указав файл решения

                :param sol_file: путь к файлу решения
        '''
    def add_variable(self, lower_bound: float = ..., upper_bound: float = ..., obj_value: float = ..., var_type: variable_type = ..., var_name: str = ...) -> Variable:
        """add_variable(self: arhiplexpy.Model, lower_bound: float = 0.0, upper_bound: float = inf, obj_value: float = 0.0, var_type: arhiplexpy.variable_type = <variable_type.continuous: 0>, var_name: str = '') -> arhiplexpy.Variable

        Добавляет переменную в модель с заданными параметрами

                :param lower_bound: нижняя граница переменной
                :param upper_bound: верхняя граница переменной
                :param obj_value: коэффициент к переменной в целевой функции
                :param var_type: тип переменной
                :param var_name: имя переменной
                :return: объект новой переменной
        """
    def binary_var_list(self, indicies: list, name: str) -> list:
        """binary_var_list(self: arhiplexpy.Model, indicies: list, name: str) -> list

        Добавляет лист бинарных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных
        """
    def clear(self) -> None:
        """clear(self: arhiplexpy.Model) -> None

        Очищает модель от всех данных. Все старые переменные и ограничения становятся невалидными
        """
    def clear_mip_start_values(self) -> None:
        """clear_mip_start_values(self: arhiplexpy.Model) -> None

        Удалить все стартовые значения для поиска решения
        """
    @overload
    def continuous_var_list(self, indicies: list, lb: list, ub: list, name: str) -> list:
        """continuous_var_list(*args, **kwargs)
        Overloaded function.

        1. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: list, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        2. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: float = inf, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        3. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: list, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        4. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: float = inf, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных
        """
    @overload
    def continuous_var_list(self, indicies: list, lb: float = ..., ub: float = ..., name: str) -> list:
        """continuous_var_list(*args, **kwargs)
        Overloaded function.

        1. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: list, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        2. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: float = inf, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        3. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: list, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        4. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: float = inf, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных
        """
    @overload
    def continuous_var_list(self, indicies: list, lb: float = ..., ub: list, name: str) -> list:
        """continuous_var_list(*args, **kwargs)
        Overloaded function.

        1. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: list, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        2. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: float = inf, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        3. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: list, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        4. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: float = inf, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных
        """
    @overload
    def continuous_var_list(self, indicies: list, lb: list, ub: float = ..., name: str) -> list:
        """continuous_var_list(*args, **kwargs)
        Overloaded function.

        1. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: list, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        2. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: float = inf, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        3. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: list, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        4. continuous_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: float = inf, name: str) -> list

        Добавляет лист непрерывных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных
        """
    def get_bool_param(self, param_name: str) -> bool:
        """get_bool_param(self: arhiplexpy.Model, param_name: str) -> bool

        Получает логический параметр

                :param param_name: имя параметра
                :return: значение параметра
        """
    def get_calc_uid(self) -> str:
        """get_calc_uid(self: arhiplexpy.Model) -> str

        Получить уникальный идентификатор последнего удаленного расчета.        :return: строку с уникальным идентификатором
        """
    @overload
    def get_constraint(self, idx: int) -> Constraint:
        """get_constraint(*args, **kwargs)
        Overloaded function.

        1. get_constraint(self: arhiplexpy.Model, idx: int) -> arhiplexpy.Constraint

        Получает ограничение из модели по индексу

                :param idx: индекс ограничения
                :return: объект ограничения

        2. get_constraint(self: arhiplexpy.Model, constr_name: str) -> arhiplexpy.Constraint

        Получает ограничение из модели по имени

                :param constr_name: имя ограничения
                :return: объект ограничения
        """
    @overload
    def get_constraint(self, constr_name: str) -> Constraint:
        """get_constraint(*args, **kwargs)
        Overloaded function.

        1. get_constraint(self: arhiplexpy.Model, idx: int) -> arhiplexpy.Constraint

        Получает ограничение из модели по индексу

                :param idx: индекс ограничения
                :return: объект ограничения

        2. get_constraint(self: arhiplexpy.Model, constr_name: str) -> arhiplexpy.Constraint

        Получает ограничение из модели по имени

                :param constr_name: имя ограничения
                :return: объект ограничения
        """
    def get_constraints_count(self) -> int:
        """get_constraints_count(self: arhiplexpy.Model) -> int

        Получает количество ограничений в модели        :return: количество ограничений в модели
        """
    def get_dbl_param(self, param_name: str) -> float:
        """get_dbl_param(self: arhiplexpy.Model, param_name: str) -> float

        Получает параметр с плавающей точкой

                :param param_name: имя параметра
                :return: значение параметра
        """
    @overload
    def get_general_constraint(self, idx: int) -> GeneralConstraint:
        """get_general_constraint(*args, **kwargs)
        Overloaded function.

        1. get_general_constraint(self: arhiplexpy.Model, idx: int) -> arhiplexpy.GeneralConstraint

        Получает общее ограничение из модели по индексу

                :param idx: индекс ограничения
                :return: объект ограничения

        2. get_general_constraint(self: arhiplexpy.Model, constr_name: str) -> arhiplexpy.GeneralConstraint

        Получает общее ограничение из модели по имени

                :param constr_name: имя ограничения
                :return: объект ограничения
        """
    @overload
    def get_general_constraint(self, constr_name: str) -> GeneralConstraint:
        """get_general_constraint(*args, **kwargs)
        Overloaded function.

        1. get_general_constraint(self: arhiplexpy.Model, idx: int) -> arhiplexpy.GeneralConstraint

        Получает общее ограничение из модели по индексу

                :param idx: индекс ограничения
                :return: объект ограничения

        2. get_general_constraint(self: arhiplexpy.Model, constr_name: str) -> arhiplexpy.GeneralConstraint

        Получает общее ограничение из модели по имени

                :param constr_name: имя ограничения
                :return: объект ограничения
        """
    def get_general_constraints_count(self) -> int:
        """get_general_constraints_count(self: arhiplexpy.Model) -> int

        Получает количество общих ограничений в модели      :return: количество общих ограничений в модели
        """
    def get_int_param(self, param_name: str) -> int:
        """get_int_param(self: arhiplexpy.Model, param_name: str) -> int

        Получает целочисленный параметр

                :param param_name: имя параметра
                :return: значение параметра
        """
    def get_name(self) -> str:
        """get_name(self: arhiplexpy.Model) -> str

        Получает имя модели

                :return: имя модели
        """
    def get_objective(self) -> LinearExpression:
        """get_objective(self: arhiplexpy.Model) -> arhiplexpy.LinearExpression

        Получает выражение целевой функции

                :return: объект выражения
        """
    def get_objective_sense(self) -> objective_sense:
        """get_objective_sense(self: arhiplexpy.Model) -> arhiplexpy.objective_sense

        Получает тип оптимизации целевой функции

                :return: тип оптимизации
        """
    def get_remote_solve_log(self, arg0: str) -> str:
        """get_remote_solve_log(self: arhiplexpy.Model, arg0: str) -> str

        Получает лог удалённого расчета 

                :param calc_uid : идентификатор удалённого расчета
                :return: лог удалённого расчета
        """
    def get_string_param(self, param_name: str) -> str:
        """get_string_param(self: arhiplexpy.Model, param_name: str) -> str

        Получает строковый параметр

                :param param_name: имя параметра
                :return: значение параметра
        """
    @overload
    def get_variable(self, idx: int) -> Variable:
        """get_variable(*args, **kwargs)
        Overloaded function.

        1. get_variable(self: arhiplexpy.Model, idx: int) -> arhiplexpy.Variable

        Получает переменную модели по индексу

                :param idx: индекс переменной
                :return: объект переменной

        2. get_variable(self: arhiplexpy.Model, var_name: str) -> arhiplexpy.Variable

        Получает переменную из модели по имени

                :param var_name: имя переменной
                :return: объект переменной
        """
    @overload
    def get_variable(self, var_name: str) -> Variable:
        """get_variable(*args, **kwargs)
        Overloaded function.

        1. get_variable(self: arhiplexpy.Model, idx: int) -> arhiplexpy.Variable

        Получает переменную модели по индексу

                :param idx: индекс переменной
                :return: объект переменной

        2. get_variable(self: arhiplexpy.Model, var_name: str) -> arhiplexpy.Variable

        Получает переменную из модели по имени

                :param var_name: имя переменной
                :return: объект переменной
        """
    def get_variables_count(self) -> int:
        """get_variables_count(self: arhiplexpy.Model) -> int

        Получает количество переменных в модели

                :return: количество переменных в модели
        """
    @overload
    def integer_var_list(self, indicies: list, lb: list, ub: list, name: str) -> list:
        """integer_var_list(*args, **kwargs)
        Overloaded function.

        1. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: list, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        2. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: float = inf, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        3. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: list, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        4. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: float = inf, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных
        """
    @overload
    def integer_var_list(self, indicies: list, lb: float = ..., ub: float = ..., name: str) -> list:
        """integer_var_list(*args, **kwargs)
        Overloaded function.

        1. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: list, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        2. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: float = inf, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        3. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: list, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        4. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: float = inf, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных
        """
    @overload
    def integer_var_list(self, indicies: list, lb: float = ..., ub: list, name: str) -> list:
        """integer_var_list(*args, **kwargs)
        Overloaded function.

        1. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: list, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        2. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: float = inf, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        3. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: list, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        4. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: float = inf, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных
        """
    @overload
    def integer_var_list(self, indicies: list, lb: list, ub: float = ..., name: str) -> list:
        """integer_var_list(*args, **kwargs)
        Overloaded function.

        1. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: list, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        2. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: float = inf, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        3. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: float = 0.0, ub: list, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: значение нижней границы (для всех переменных)
                        :param ub: список верхних границ
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных

        4. integer_var_list(self: arhiplexpy.Model, indicies: list, lb: list, ub: float = inf, name: str) -> list

        Добавляет лист целочисленных переменных

                        :param indicies: список индексов, добавляемых к начальному имени (или список кортежей)
                        :param lb: список нижних границ
                        :param ub: значение верхней границы (для всех переменных)
                        :param name: префикс имени каждой добавленной переменной
                        :return: список переменных
        """
    def is_mip(self) -> bool:
        """is_mip(self: arhiplexpy.Model) -> bool

        Проверяет является ли задача целочисленной
        """
    def is_nonlinear(self) -> bool:
        """is_nonlinear(self: arhiplexpy.Model) -> bool

        Проверяет является ли задача нелинейной
        """
    def read(self, file_name: str) -> None:
        """read(self: arhiplexpy.Model, file_name: str) -> None

        Читает модель из файла

                :param file_name: имя файла

        """
    def read_lp(self, file_name: str) -> None:
        """read_lp(self: arhiplexpy.Model, file_name: str) -> None

        Читает модель из файла,         при этом он будет читаться как LP файл независимо от расширения

                :param file_name: путь к файлу модели
        """
    def read_mps(self, file_name: str) -> None:
        """read_mps(self: arhiplexpy.Model, file_name: str) -> None

        Читает модель из файла,         при этом он будет читаться как MPS файл независимо от расширения

                :param file_name: путь к файлу модели
        """
    @overload
    def remove(self, constr: Constraint) -> None:
        """remove(*args, **kwargs)
        Overloaded function.

        1. remove(self: arhiplexpy.Model, constr: arhiplexpy.Constraint) -> None

        Удаляет ограничение из модели

                :param constr: ограничение

        2. remove(self: arhiplexpy.Model, var: arhiplexpy.Variable) -> None

        Удаляет переменную из модели

                :param var: переменная

        3. remove(self: arhiplexpy.Model, constr: arhiplexpy.GeneralConstraint) -> None

        Удаляет общее ограничение из модели

                :param constr: общее ограничение
        """
    @overload
    def remove(self, var: Variable) -> None:
        """remove(*args, **kwargs)
        Overloaded function.

        1. remove(self: arhiplexpy.Model, constr: arhiplexpy.Constraint) -> None

        Удаляет ограничение из модели

                :param constr: ограничение

        2. remove(self: arhiplexpy.Model, var: arhiplexpy.Variable) -> None

        Удаляет переменную из модели

                :param var: переменная

        3. remove(self: arhiplexpy.Model, constr: arhiplexpy.GeneralConstraint) -> None

        Удаляет общее ограничение из модели

                :param constr: общее ограничение
        """
    @overload
    def remove(self, constr: GeneralConstraint) -> None:
        """remove(*args, **kwargs)
        Overloaded function.

        1. remove(self: arhiplexpy.Model, constr: arhiplexpy.Constraint) -> None

        Удаляет ограничение из модели

                :param constr: ограничение

        2. remove(self: arhiplexpy.Model, var: arhiplexpy.Variable) -> None

        Удаляет переменную из модели

                :param var: переменная

        3. remove(self: arhiplexpy.Model, constr: arhiplexpy.GeneralConstraint) -> None

        Удаляет общее ограничение из модели

                :param constr: общее ограничение
        """
    def set_bool_param(self, param_name: str, param_value: bool) -> None:
        """set_bool_param(self: arhiplexpy.Model, param_name: str, param_value: bool) -> None

        Задаёт логический параметр

                :param param_name: имя параметра
                :param param_value: значение параметра
        """
    def set_dbl_param(self, param_name: str, param_value: float) -> None:
        """set_dbl_param(self: arhiplexpy.Model, param_name: str, param_value: float) -> None

        Задаёт параметр с плавающей точкой

                :param param_name: имя параметра
                :param param_value: значение параметра
        """
    def set_int_param(self, param_name: str, param_value: int) -> None:
        """set_int_param(self: arhiplexpy.Model, param_name: str, param_value: int) -> None

        Задаёт целочисленный параметр

                :param param_name: имя параметра
                :param param_value: значение параметра
        """
    def set_log_callback(self, callback: object) -> None:
        """set_log_callback(self: arhiplexpy.Model, callback: object) -> None

        Задаёт функтор обратного вызова для вывода сообщений от солвера

                :param callback: функтор обратного вызова
        """
    def set_log_file(self, log_file: str) -> None:
        """set_log_file(self: arhiplexpy.Model, log_file: str) -> None

        Задать файл для записи лога решения

                :param log_file файл лога
        """
    def set_name(self, expr_name: str) -> None:
        """set_name(self: arhiplexpy.Model, expr_name: str) -> None

        Задаёт имя модели

                :param expr_name: имя модели
        """
    @overload
    def set_objective(self, var: Variable, sense: objective_sense) -> None:
        """set_objective(*args, **kwargs)
        Overloaded function.

        1. set_objective(self: arhiplexpy.Model, var: arhiplexpy.Variable, sense: arhiplexpy.objective_sense) -> None

        Задаёт переменную для оптимизации и тип

                :param var: переменная
                :param sense: тип оптимизации

        2. set_objective(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, sense: arhiplexpy.objective_sense) -> None

        Задаёт выражение целевой функции и тип оптимизации

                :param expr: выражение
                :param sense: тип оптимизации

        3. set_objective(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, sense: arhiplexpy.objective_sense) -> None

        Задаёт выражение целевой функции и тип оптимизации

                :param expr: выражение
                :param sense: тип оптимизации
        """
    @overload
    def set_objective(self, expr: LinearExpression, sense: objective_sense) -> None:
        """set_objective(*args, **kwargs)
        Overloaded function.

        1. set_objective(self: arhiplexpy.Model, var: arhiplexpy.Variable, sense: arhiplexpy.objective_sense) -> None

        Задаёт переменную для оптимизации и тип

                :param var: переменная
                :param sense: тип оптимизации

        2. set_objective(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, sense: arhiplexpy.objective_sense) -> None

        Задаёт выражение целевой функции и тип оптимизации

                :param expr: выражение
                :param sense: тип оптимизации

        3. set_objective(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, sense: arhiplexpy.objective_sense) -> None

        Задаёт выражение целевой функции и тип оптимизации

                :param expr: выражение
                :param sense: тип оптимизации
        """
    @overload
    def set_objective(self, expr: QuadExpression, sense: objective_sense) -> None:
        """set_objective(*args, **kwargs)
        Overloaded function.

        1. set_objective(self: arhiplexpy.Model, var: arhiplexpy.Variable, sense: arhiplexpy.objective_sense) -> None

        Задаёт переменную для оптимизации и тип

                :param var: переменная
                :param sense: тип оптимизации

        2. set_objective(self: arhiplexpy.Model, expr: arhiplexpy.LinearExpression, sense: arhiplexpy.objective_sense) -> None

        Задаёт выражение целевой функции и тип оптимизации

                :param expr: выражение
                :param sense: тип оптимизации

        3. set_objective(self: arhiplexpy.Model, expr: arhiplexpy.QuadExpression, sense: arhiplexpy.objective_sense) -> None

        Задаёт выражение целевой функции и тип оптимизации

                :param expr: выражение
                :param sense: тип оптимизации
        """
    def set_objective_offset(self, offset: float) -> None:
        """set_objective_offset(self: arhiplexpy.Model, offset: float) -> None

        Задаёт константу в выражении целевой функции

                :param offset: значение константы
        """
    def set_objective_sense(self, constr_name: objective_sense) -> None:
        """set_objective_sense(self: arhiplexpy.Model, constr_name: arhiplexpy.objective_sense) -> None

        Задаёт тип оптимизации целевой функции - максимизация или минимизация

                :param sense: тип оптимизации
        """
    def set_string_param(self, param_name: str, param_value: str) -> None:
        """set_string_param(self: arhiplexpy.Model, param_name: str, param_value: str) -> None

        Задаёт строковый параметр

                :param param_name: имя параметра
                :param param_value: значение параметра
        """
    def solve(self) -> SolveResult:
        """solve(self: arhiplexpy.Model) -> arhiplexpy.SolveResult

        Стартует оптимизацию модели

                :return: объект с результатом оптимизации
        """
    def solve_remote(self, name_mapping_file: str) -> SolveResult:
        """solve_remote(self: arhiplexpy.Model, name_mapping_file: str) -> arhiplexpy.SolveResult

        Стартует оптимизацию модели на удаленном сервере в синхронном режиме.         Предварительно необходимо установить переменную окружения X_API_KEY.

                :param name_mapping_file путь к файлу, который будет записан и будет содержать соответствие оригинальных имен модели и анонимизированных         :return: объект с результатом оптимизации
        """
    def solve_remote_async(self, name_mapping_file: str) -> None:
        """solve_remote_async(self: arhiplexpy.Model, name_mapping_file: str) -> None

        Стартует оптимизацию модели на удаленном сервере         в асинхронном режиме без ожидания результата.         Предварительно необходимо установить переменную окружения X_API_KEY.n
                :param name_mapping_file путь к файлу, который будет записан и будет содержать соответствие оригинальных имен модели и анонимизированных
        """
    def write(self, file_name: str, name_mapping_file: str = ...) -> None:
        """write(self: arhiplexpy.Model, file_name: str, name_mapping_file: str = '') -> None

        Записывает модель в файл. Тип будет определен по расширению

                :param file_name: путь к записываемому файлу
                :param name_mapping_file путь к файлу, который будет содержать             соответствие между именами модели при анонимизации (если пустой - запись             без анонимизации)
        """
    def write_lp(self, file_name: str, name_mapping_file: str = ...) -> None:
        """write_lp(self: arhiplexpy.Model, file_name: str, name_mapping_file: str = '') -> None

        Записывает модель в файл в формате LP

                :param file_name: путь к записываемому файлу

                :param name_mapping_file путь к файлу, который будет содержать             соответствие между именами модели при анонимизации (если пустой - запись             без анонимизации)
        """
    def write_mps(self, file_name: str, name_mapping_file: str = ...) -> None:
        """write_mps(self: arhiplexpy.Model, file_name: str, name_mapping_file: str = '') -> None

        Записывает модель в файл в формате MPS

                :param file_name: путь к записываемому файлу

                :param name_mapping_file путь к файлу, который будет содержать             соответствие между именами модели при анонимизации (если пустой - запись             без анонимизации)
        """

class QuadExpression:
    """Обеспечивает работу с нелинейными выражениями -     добавление/удаление элементов и изменение коэффициентов.    Элемент выражения - переменная * переменная * коэффициент."""
    def __init__(self) -> None:
        """__init__(self: arhiplexpy.QuadExpression) -> None

        Создает пустое выражение
        """
    @overload
    def add_expression(self, expr: QuadExpression, mult: float) -> None:
        """add_expression(*args, **kwargs)
        Overloaded function.

        1. add_expression(self: arhiplexpy.QuadExpression, expr: arhiplexpy.QuadExpression, mult: float) -> None

        Добавляет выражение к выражению

                :param expr: добавляемое выражение
                :param mult: коэффициент к добавляемому выражению

        2. add_expression(self: arhiplexpy.QuadExpression, expr: arhiplexpy.LinearExpression, mult: float) -> None

        Добавляет выражение к выражению

                :param expr: добавляемое выражение
                :param mult: коэффициент к добавляемому выражению
        """
    @overload
    def add_expression(self, expr: LinearExpression, mult: float) -> None:
        """add_expression(*args, **kwargs)
        Overloaded function.

        1. add_expression(self: arhiplexpy.QuadExpression, expr: arhiplexpy.QuadExpression, mult: float) -> None

        Добавляет выражение к выражению

                :param expr: добавляемое выражение
                :param mult: коэффициент к добавляемому выражению

        2. add_expression(self: arhiplexpy.QuadExpression, expr: arhiplexpy.LinearExpression, mult: float) -> None

        Добавляет выражение к выражению

                :param expr: добавляемое выражение
                :param mult: коэффициент к добавляемому выражению
        """
    def add_term(self, var1: Variable, var2: Variable, coeff: float = ...) -> None:
        """add_term(self: arhiplexpy.QuadExpression, var1: arhiplexpy.Variable, var2: arhiplexpy.Variable, coeff: float = 1.0) -> None

        Добавляет элемент к выражению

                :param var1: переменная 1
                :param var2: переменная 2
                :param coeff: коэффициент
        """
    def copy(self) -> QuadExpression:
        """copy(self: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression

        Создает копию выражения, не привязанную к модели         или другому ограничению

                :return: копия выражения
        """
    def empty(self) -> bool:
        """empty(self: arhiplexpy.QuadExpression) -> bool

        Возвращает истину, если выражение пустое
                :return: истина, если выражение пустое
        """
    def get_linear_part(self) -> LinearExpression:
        """get_linear_part(self: arhiplexpy.QuadExpression) -> arhiplexpy.LinearExpression

        Получает линейную часть выражения
                :return: линейная часть выражения
        """
    def get_name(self) -> str:
        """get_name(self: arhiplexpy.QuadExpression) -> str

        Получает имя выражения

                :return: имя выражения
        """
    def get_term_coeff(self, ind: int) -> float:
        """get_term_coeff(self: arhiplexpy.QuadExpression, ind: int) -> float

        Возвращает коэффициент по индексу элемента в выражении

                :param ind: индекс элемента в выражении
                :return: значение коэффициента
        """
    def get_term_variable1(self, ind: int) -> Variable:
        """get_term_variable1(self: arhiplexpy.QuadExpression, ind: int) -> arhiplexpy.Variable

        Возвращает первую переменную по индексу элемента в выражении

                :param ind: индекс элемента в выражении
                :return: объект переменной
        """
    def get_term_variable2(self, ind: int) -> Variable:
        """get_term_variable2(self: arhiplexpy.QuadExpression, ind: int) -> arhiplexpy.Variable

        Возвращает вторую переменную по индексу элемента в выражении

                :param ind: индекс элемента в выражении
                :return: объект переменной
        """
    def get_terms_count(self) -> int:
        """get_terms_count(self: arhiplexpy.QuadExpression) -> int

        Возвращает количество элементов в выражении

                :return: количество элементов в выражении
        """
    def remove_term(self, idx: int) -> None:
        """remove_term(self: arhiplexpy.QuadExpression, idx: int) -> None

        Удаляет элемент выражения по индексу

                :param idx: индекс удаляемого элемента в выражении
        """
    def set_name(self, expr_name: str) -> None:
        """set_name(self: arhiplexpy.QuadExpression, expr_name: str) -> None

        Задаёт имя выражения

                :param expr_name: имя выражения
        """
    def set_term_coeff(self, ind: int, value: float) -> None:
        """set_term_coeff(self: arhiplexpy.QuadExpression, ind: int, value: float) -> None

        Задает коэффициент по индексу выражения

                :param ind: индекс элемента в выражении
                :param value: значение коэффициента в элементе
        """
    @overload
    def __add__(self, arg0: float) -> QuadExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __add__(self, arg0: Variable) -> QuadExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __add__(self, arg0: LinearExpression) -> QuadExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __add__(self, arg0: QuadExpression) -> QuadExpression:
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __add__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __eq__(self, arg0: Variable) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        4. __eq__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __eq__(self, arg0: LinearExpression) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        4. __eq__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __eq__(self, arg0: QuadExpression) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        4. __eq__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __eq__(self, arg0: float) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        4. __eq__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0: QuadExpression) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        4. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        5. __ge__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0: Variable) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        4. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        5. __ge__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0: LinearExpression) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        4. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        5. __ge__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0: QuadExpression) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        4. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        5. __ge__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0: float) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        4. __ge__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        5. __ge__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __iadd__(self, arg0: float) -> QuadExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __iadd__(self, arg0: Variable) -> QuadExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __iadd__(self, arg0: LinearExpression) -> QuadExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __iadd__(self, arg0: QuadExpression) -> QuadExpression:
        """__iadd__(*args, **kwargs)
        Overloaded function.

        1. __iadd__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __iadd__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    def __imul__(self, arg0: float) -> QuadExpression:
        """__imul__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression"""
    @overload
    def __isub__(self, arg0: float) -> QuadExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __isub__(self, arg0: Variable) -> QuadExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __isub__(self, arg0: LinearExpression) -> QuadExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    @overload
    def __isub__(self, arg0: QuadExpression) -> QuadExpression:
        """__isub__(*args, **kwargs)
        Overloaded function.

        1. __isub__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        2. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        3. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        4. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __isub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression
        """
    def __itruediv__(self, arg0: float) -> QuadExpression:
        """__itruediv__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression"""
    @overload
    def __le__(self, arg0: Variable) -> Constraint:
        """__le__(*args, **kwargs)
        Overloaded function.

        1. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        4. __le__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __le__(self, arg0: LinearExpression) -> Constraint:
        """__le__(*args, **kwargs)
        Overloaded function.

        1. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        4. __le__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __le__(self, arg0: QuadExpression) -> Constraint:
        """__le__(*args, **kwargs)
        Overloaded function.

        1. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        4. __le__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    @overload
    def __le__(self, arg0: float) -> Constraint:
        """__le__(*args, **kwargs)
        Overloaded function.

        1. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.Constraint

        3. __le__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.Constraint

        4. __le__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.Constraint
        """
    def __mul__(self, arg0: float) -> QuadExpression:
        """__mul__(*args, **kwargs)
        Overloaded function.

        1. __mul__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplex::GeneralExpression

        2. __mul__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplex::GeneralExpression

        3. __mul__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplex::GeneralExpression

        4. __mul__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __mul__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression
        """
    def __neg__(self) -> QuadExpression:
        """__neg__(self: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression"""
    def __pow__(self, other):
        """__pow__(self: arhiplexpy.QuadExpression, arg0: int) -> Union[float, arhiplexpy.Variable, arhiplexpy.LinearExpression, arhiplexpy.QuadExpression, arhiplex::GeneralExpression]"""
    def __radd__(self, arg0: float) -> QuadExpression:
        """__radd__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression"""
    def __rmul__(self, arg0: float) -> QuadExpression:
        """__rmul__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression"""
    def __rsub__(self, arg0: float) -> QuadExpression:
        """__rsub__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression"""
    @overload
    def __sub__(self, arg0: QuadExpression) -> QuadExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression

        2. __sub__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        3. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        4. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        5. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression
        """
    @overload
    def __sub__(self, arg0: float) -> QuadExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression

        2. __sub__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        3. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        4. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        5. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression
        """
    @overload
    def __sub__(self, arg0: Variable) -> QuadExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression

        2. __sub__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        3. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        4. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        5. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression
        """
    @overload
    def __sub__(self, arg0: LinearExpression) -> QuadExpression:
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplexpy.QuadExpression

        2. __sub__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression

        3. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplexpy.QuadExpression

        4. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplexpy.QuadExpression

        5. __sub__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression
        """
    def __truediv__(self, arg0: float) -> QuadExpression:
        """__truediv__(*args, **kwargs)
        Overloaded function.

        1. __truediv__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.Variable) -> arhiplex::GeneralExpression

        2. __truediv__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.LinearExpression) -> arhiplex::GeneralExpression

        3. __truediv__(self: arhiplexpy.QuadExpression, arg0: arhiplexpy.QuadExpression) -> arhiplex::GeneralExpression

        4. __truediv__(self: arhiplexpy.QuadExpression, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression

        5. __truediv__(self: arhiplexpy.QuadExpression, arg0: float) -> arhiplexpy.QuadExpression
        """

class SolveResult:
    """Результат расчета"""
    def __init__(self, calc_uid: str, name_mapping_file: str) -> None:
        """__init__(self: arhiplexpy.SolveResult, calc_uid: str, name_mapping_file: str) -> None"""
    def get_best_bound(self) -> float:
        """get_best_bound(self: arhiplexpy.SolveResult) -> float

        Получает значение граничной (двойственной) функции

                :return: значение граничной (двойственной) функции
        """
    @overload
    def get_dual_value(self, constraint) -> float:
        """get_dual_value(*args, **kwargs)
        Overloaded function.

        1. get_dual_value(self: arhiplexpy.SolveResult, constraint: arhiplex::Constraint) -> float

        Получает значение dual value

                :param constraint: ограничение
                :return: значение dual value в решении

        2. get_dual_value(self: arhiplexpy.SolveResult, constraint_name: str) -> float

        Получает значение dual value по имени ограниения

                :param constraint_name: имя ограничения
                :return: значение dual value в решении
        """
    @overload
    def get_dual_value(self, constraint_name: str) -> float:
        """get_dual_value(*args, **kwargs)
        Overloaded function.

        1. get_dual_value(self: arhiplexpy.SolveResult, constraint: arhiplex::Constraint) -> float

        Получает значение dual value

                :param constraint: ограничение
                :return: значение dual value в решении

        2. get_dual_value(self: arhiplexpy.SolveResult, constraint_name: str) -> float

        Получает значение dual value по имени ограниения

                :param constraint_name: имя ограничения
                :return: значение dual value в решении
        """
    @overload
    def get_expression_value(self, arg0) -> float:
        """get_expression_value(*args, **kwargs)
        Overloaded function.

        1. get_expression_value(self: arhiplexpy.SolveResult, arg0: arhiplex::QuadExpression) -> float

        Получает значение выражения

                :param expr: объект выражения
                :return: значение выражения

        2. get_expression_value(self: arhiplexpy.SolveResult, arg0: arhiplex::LinearExpression) -> float

        Получает значение выражения

                :param expr: объект выражения
                :return: значение выражения
        """
    @overload
    def get_expression_value(self, arg0) -> float:
        """get_expression_value(*args, **kwargs)
        Overloaded function.

        1. get_expression_value(self: arhiplexpy.SolveResult, arg0: arhiplex::QuadExpression) -> float

        Получает значение выражения

                :param expr: объект выражения
                :return: значение выражения

        2. get_expression_value(self: arhiplexpy.SolveResult, arg0: arhiplex::LinearExpression) -> float

        Получает значение выражения

                :param expr: объект выражения
                :return: значение выражения
        """
    def get_iterations_count(self) -> int:
        """get_iterations_count(self: arhiplexpy.SolveResult) -> int

        Получает количество итераций, проведенных в процессе расчета

                :return: количество итераций
        """
    def get_nodes_count(self) -> int:
        """get_nodes_count(self: arhiplexpy.SolveResult) -> int

        Получает количество обработанных узлов дерева решений

                :return: количество обработанных узлов
        """
    def get_objective_value(self) -> float:
        """get_objective_value(self: arhiplexpy.SolveResult) -> float

        Получает значение целевой функции

                :return: значение целевой функции
        """
    @overload
    def get_reduced_cost(self, var_name: str) -> float:
        """get_reduced_cost(*args, **kwargs)
        Overloaded function.

        1. get_reduced_cost(self: arhiplexpy.SolveResult, var_name: str) -> float

        Получает значение reduced cost в решении по имени

                :param var_name: имя переменной
                :return: значение reduced cost в решении

        2. get_reduced_cost(self: arhiplexpy.SolveResult, variable: arhiplex::Variable) -> float

        Получает значение reduced cost в решении 

                :param variable: переменная
                :return: значение reduced cost в решении
        """
    @overload
    def get_reduced_cost(self, variable) -> float:
        """get_reduced_cost(*args, **kwargs)
        Overloaded function.

        1. get_reduced_cost(self: arhiplexpy.SolveResult, var_name: str) -> float

        Получает значение reduced cost в решении по имени

                :param var_name: имя переменной
                :return: значение reduced cost в решении

        2. get_reduced_cost(self: arhiplexpy.SolveResult, variable: arhiplex::Variable) -> float

        Получает значение reduced cost в решении 

                :param variable: переменная
                :return: значение reduced cost в решении
        """
    def get_relative_gap(self) -> float:
        """get_relative_gap(self: arhiplexpy.SolveResult) -> float

        Получает точность решения в процентах

                :return: точность решения в процентах
        """
    def get_solution_status(self) -> solution_status:
        """get_solution_status(self: arhiplexpy.SolveResult) -> arhiplexpy.solution_status

        Получает статус модели в итоге расчета

                :return: значение статуса
        """
    def get_solve_result(self) -> solve_result:
        """get_solve_result(self: arhiplexpy.SolveResult) -> arhiplexpy.solve_result

        Получает статус процесса расчетов

                :return: значение статуса
        """
    def get_solve_time(self) -> float:
        """get_solve_time(self: arhiplexpy.SolveResult) -> float

        Получает общее время решения

                :return: общее время решения [сек]
        """
    @overload
    def get_variable_value(self, var) -> float:
        """get_variable_value(*args, **kwargs)
        Overloaded function.

        1. get_variable_value(self: arhiplexpy.SolveResult, var: arhiplex::Variable) -> float

        Получает значение переменной в решении

                :param var: объект переменной
                :return: значение переменной в решении

        2. get_variable_value(self: arhiplexpy.SolveResult, var_name: str) -> float

        Получает значение переменной в решении по имени

                :param var_name: имя переменной
                :return: значение переменной в решении
        """
    @overload
    def get_variable_value(self, var_name: str) -> float:
        """get_variable_value(*args, **kwargs)
        Overloaded function.

        1. get_variable_value(self: arhiplexpy.SolveResult, var: arhiplex::Variable) -> float

        Получает значение переменной в решении

                :param var: объект переменной
                :return: значение переменной в решении

        2. get_variable_value(self: arhiplexpy.SolveResult, var_name: str) -> float

        Получает значение переменной в решении по имени

                :param var_name: имя переменной
                :return: значение переменной в решении
        """
    def write_solution(self, file_name: str) -> None:
        """write_solution(self: arhiplexpy.SolveResult, file_name: str) -> None

        Записывает решение в файл

                :param file_name: путь к файлу решения для записи
        """

class Variable:
    """Работа с переменной - чтение/изменение имени,     верхней и нижней границы, типа, а также удаление"""
    def __init__(self, *args, **kwargs) -> None:
        """Initialize self.  See help(type(self)) for accurate signature."""
    def get_lower_bound(self) -> float:
        """get_lower_bound(self: arhiplexpy.Variable) -> float

        Получает нижнюю границу переменной

                :return: нижнюю границу переменной
        """
    def get_name(self) -> str:
        """get_name(self: arhiplexpy.Variable) -> str

        Получает имя переменной в модели

                :return: имя переменной
        """
    def get_type(self) -> variable_type:
        """get_type(self: arhiplexpy.Variable) -> arhiplexpy.variable_type

        Получает тип переменной

                :return: тип переменной
        """
    def get_upper_bound(self) -> float:
        """get_upper_bound(self: arhiplexpy.Variable) -> float

        Получает верхнюю границу переменной

                :return: верхнюю границу переменной
        """
    def remove(self) -> None:
        """remove(self: arhiplexpy.Variable) -> None

        Помечает переменную как удаленную. Переменная не будет участвовать в расчетах
        """
    def set_lower_bound(self, lower_bound: float) -> None:
        """set_lower_bound(self: arhiplexpy.Variable, lower_bound: float) -> None

        Задаёт нижнюю границу для переменной

                :param lower_bound: новая нижняя граница переменной
        """
    def set_name(self, var_name: str) -> None:
        """set_name(self: arhiplexpy.Variable, var_name: str) -> None

        Задаёт имя переменной в модели

                :param var_name: имя переменной
        """
    def set_type(self, type: variable_type) -> None:
        """set_type(self: arhiplexpy.Variable, type: arhiplexpy.variable_type) -> None

        Задает новый тип переменной в модели

                :param type: новый тип переменной
        """
    def set_upper_bound(self, upper_bound: float) -> None:
        """set_upper_bound(self: arhiplexpy.Variable, upper_bound: float) -> None

        Задаёт верхнюю границу для переменной

                :param upper_bound: новая верхняя граница переменной
        """
    def __add__(self, other):
        """__add__(*args, **kwargs)
        Overloaded function.

        1. __add__(self: arhiplexpy.Variable, arg0: float) -> arhiplex::LinearExpression

        2. __add__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplex::LinearExpression

        3. __add__(self: arhiplexpy.Variable, arg0: arhiplex::LinearExpression) -> arhiplex::LinearExpression

        4. __add__(self: arhiplexpy.Variable, arg0: arhiplex::QuadExpression) -> arhiplex::QuadExpression

        5. __add__(self: arhiplexpy.Variable, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression
        """
    @overload
    def __eq__(self, arg0: Variable) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.Variable, arg0: arhiplex::GeneralExpression) -> arhiplexpy.GeneralConstraint
        """
    @overload
    def __eq__(self, arg0: float) -> Constraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.Variable, arg0: arhiplex::GeneralExpression) -> arhiplexpy.GeneralConstraint
        """
    @overload
    def __eq__(self, arg0) -> GeneralConstraint:
        """__eq__(*args, **kwargs)
        Overloaded function.

        1. __eq__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        2. __eq__(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.Constraint

        3. __eq__(self: arhiplexpy.Variable, arg0: arhiplex::GeneralExpression) -> arhiplexpy.GeneralConstraint
        """
    @overload
    def __ge__(self, arg0: float) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.Variable, arg0: arhiplex::LinearExpression) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0: Variable) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.Variable, arg0: arhiplex::LinearExpression) -> arhiplexpy.Constraint
        """
    @overload
    def __ge__(self, arg0) -> Constraint:
        """__ge__(*args, **kwargs)
        Overloaded function.

        1. __ge__(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.Constraint

        2. __ge__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplexpy.Constraint

        3. __ge__(self: arhiplexpy.Variable, arg0: arhiplex::LinearExpression) -> arhiplexpy.Constraint
        """
    def __le__(self, arg0: float) -> Constraint:
        """__le__(self: arhiplexpy.Variable, arg0: float) -> arhiplexpy.Constraint"""
    def __mul__(self, other):
        """__mul__(*args, **kwargs)
        Overloaded function.

        1. __mul__(self: arhiplexpy.Variable, arg0: float) -> arhiplex::LinearExpression

        2. __mul__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplex::QuadExpression

        3. __mul__(self: arhiplexpy.Variable, arg0: arhiplex::LinearExpression) -> arhiplex::QuadExpression

        4. __mul__(self: arhiplexpy.Variable, arg0: arhiplex::QuadExpression) -> arhiplex::GeneralExpression

        5. __mul__(self: arhiplexpy.Variable, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression
        """
    def __neg__(self):
        """__neg__(self: arhiplexpy.Variable) -> arhiplex::LinearExpression"""
    def __pow__(self, other):
        """__pow__(self: arhiplexpy.Variable, arg0: int) -> Union[float, arhiplexpy.Variable, arhiplex::LinearExpression, arhiplex::QuadExpression, arhiplex::GeneralExpression]"""
    def __radd__(self, other):
        """__radd__(self: arhiplexpy.Variable, arg0: float) -> arhiplex::LinearExpression"""
    def __rmul__(self, other):
        """__rmul__(*args, **kwargs)
        Overloaded function.

        1. __rmul__(self: arhiplexpy.Variable, arg0: float) -> arhiplex::LinearExpression

        2. __rmul__(self: arhiplexpy.Variable, arg0: float) -> arhiplex::LinearExpression
        """
    def __rsub__(self, other):
        """__rsub__(self: arhiplexpy.Variable, arg0: float) -> arhiplex::LinearExpression"""
    def __sub__(self, other):
        """__sub__(*args, **kwargs)
        Overloaded function.

        1. __sub__(self: arhiplexpy.Variable, arg0: float) -> arhiplex::LinearExpression

        2. __sub__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplex::LinearExpression

        3. __sub__(self: arhiplexpy.Variable, arg0: arhiplex::LinearExpression) -> arhiplex::LinearExpression

        4. __sub__(self: arhiplexpy.Variable, arg0: arhiplex::QuadExpression) -> arhiplex::QuadExpression

        5. __sub__(self: arhiplexpy.Variable, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression
        """
    def __truediv__(self, other):
        """__truediv__(*args, **kwargs)
        Overloaded function.

        1. __truediv__(self: arhiplexpy.Variable, arg0: float) -> arhiplex::LinearExpression

        2. __truediv__(self: arhiplexpy.Variable, arg0: arhiplexpy.Variable) -> arhiplex::GeneralExpression

        3. __truediv__(self: arhiplexpy.Variable, arg0: arhiplex::LinearExpression) -> arhiplex::GeneralExpression

        4. __truediv__(self: arhiplexpy.Variable, arg0: arhiplex::QuadExpression) -> arhiplex::GeneralExpression

        5. __truediv__(self: arhiplexpy.Variable, arg0: arhiplex::GeneralExpression) -> arhiplex::GeneralExpression
        """

class constraint_sense:
    """Members:

      equal

      less_equal

      greater_equal"""
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    equal: ClassVar[constraint_sense] = ...
    greater_equal: ClassVar[constraint_sense] = ...
    less_equal: ClassVar[constraint_sense] = ...
    def __init__(self, value: int) -> None:
        """__init__(self: arhiplexpy.constraint_sense, value: int) -> None"""
    def __eq__(self, other: object) -> bool:
        """__eq__(self: object, other: object) -> bool"""
    def __hash__(self) -> int:
        """__hash__(self: object) -> int"""
    def __index__(self) -> int:
        """__index__(self: arhiplexpy.constraint_sense) -> int"""
    def __int__(self) -> int:
        """__int__(self: arhiplexpy.constraint_sense) -> int"""
    def __ne__(self, other: object) -> bool:
        """__ne__(self: object, other: object) -> bool"""
    @property
    def name(self) -> str:
        """name(self: handle) -> str

        name(self: handle) -> str
        """
    @property
    def value(self) -> int:
        """(arg0: arhiplexpy.constraint_sense) -> int"""

class gen_expr_type:
    """Members:

      constant

      variable

      minus

      plus

      divide

      multiply

      func_square_root

      func_sqr

      func_pow

      func_exp

      func_log

      func_log2

      func_log10

      func_sin

      func_cos

      func_tan

      func_logistic

      func_tanh

      func_signpow"""
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    constant: ClassVar[gen_expr_type] = ...
    divide: ClassVar[gen_expr_type] = ...
    func_cos: ClassVar[gen_expr_type] = ...
    func_exp: ClassVar[gen_expr_type] = ...
    func_log: ClassVar[gen_expr_type] = ...
    func_log10: ClassVar[gen_expr_type] = ...
    func_log2: ClassVar[gen_expr_type] = ...
    func_logistic: ClassVar[gen_expr_type] = ...
    func_pow: ClassVar[gen_expr_type] = ...
    func_signpow: ClassVar[gen_expr_type] = ...
    func_sin: ClassVar[gen_expr_type] = ...
    func_sqr: ClassVar[gen_expr_type] = ...
    func_square_root: ClassVar[gen_expr_type] = ...
    func_tan: ClassVar[gen_expr_type] = ...
    func_tanh: ClassVar[gen_expr_type] = ...
    minus: ClassVar[gen_expr_type] = ...
    multiply: ClassVar[gen_expr_type] = ...
    plus: ClassVar[gen_expr_type] = ...
    variable: ClassVar[gen_expr_type] = ...
    def __init__(self, value: int) -> None:
        """__init__(self: arhiplexpy.gen_expr_type, value: int) -> None"""
    def __eq__(self, other: object) -> bool:
        """__eq__(self: object, other: object) -> bool"""
    def __hash__(self) -> int:
        """__hash__(self: object) -> int"""
    def __index__(self) -> int:
        """__index__(self: arhiplexpy.gen_expr_type) -> int"""
    def __int__(self) -> int:
        """__int__(self: arhiplexpy.gen_expr_type) -> int"""
    def __ne__(self, other: object) -> bool:
        """__ne__(self: object, other: object) -> bool"""
    @property
    def name(self) -> str:
        """name(self: handle) -> str

        name(self: handle) -> str
        """
    @property
    def value(self) -> int:
        """(arg0: arhiplexpy.gen_expr_type) -> int"""

class objective_sense:
    """Members:

      minimize

      maximize"""
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    maximize: ClassVar[objective_sense] = ...
    minimize: ClassVar[objective_sense] = ...
    def __init__(self, value: int) -> None:
        """__init__(self: arhiplexpy.objective_sense, value: int) -> None"""
    def __eq__(self, other: object) -> bool:
        """__eq__(self: object, other: object) -> bool"""
    def __hash__(self) -> int:
        """__hash__(self: object) -> int"""
    def __index__(self) -> int:
        """__index__(self: arhiplexpy.objective_sense) -> int"""
    def __int__(self) -> int:
        """__int__(self: arhiplexpy.objective_sense) -> int"""
    def __ne__(self, other: object) -> bool:
        """__ne__(self: object, other: object) -> bool"""
    @property
    def name(self) -> str:
        """name(self: handle) -> str

        name(self: handle) -> str
        """
    @property
    def value(self) -> int:
        """(arg0: arhiplexpy.objective_sense) -> int"""

class solution_status:
    """Members:

      invalid_solution

      optimal

      feasible

      infeasible

      unbounded

      infeasible_or_unbounded"""
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    feasible: ClassVar[solution_status] = ...
    infeasible: ClassVar[solution_status] = ...
    infeasible_or_unbounded: ClassVar[solution_status] = ...
    invalid_solution: ClassVar[solution_status] = ...
    optimal: ClassVar[solution_status] = ...
    unbounded: ClassVar[solution_status] = ...
    def __init__(self, value: int) -> None:
        """__init__(self: arhiplexpy.solution_status, value: int) -> None"""
    def __eq__(self, other: object) -> bool:
        """__eq__(self: object, other: object) -> bool"""
    def __hash__(self) -> int:
        """__hash__(self: object) -> int"""
    def __index__(self) -> int:
        """__index__(self: arhiplexpy.solution_status) -> int"""
    def __int__(self) -> int:
        """__int__(self: arhiplexpy.solution_status) -> int"""
    def __ne__(self, other: object) -> bool:
        """__ne__(self: object, other: object) -> bool"""
    @property
    def name(self) -> str:
        """name(self: handle) -> str

        name(self: handle) -> str
        """
    @property
    def value(self) -> int:
        """(arg0: arhiplexpy.solution_status) -> int"""

class solve_result:
    """Members:

      success

      fail

      remote_invalid_api_key

      remote_api_key_not_set

      remote_time_amount_is_over

      remote_time_per_calc_violated

      remote_fail"""
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    fail: ClassVar[solve_result] = ...
    remote_api_key_not_set: ClassVar[solve_result] = ...
    remote_fail: ClassVar[solve_result] = ...
    remote_invalid_api_key: ClassVar[solve_result] = ...
    remote_time_amount_is_over: ClassVar[solve_result] = ...
    remote_time_per_calc_violated: ClassVar[solve_result] = ...
    success: ClassVar[solve_result] = ...
    def __init__(self, value: int) -> None:
        """__init__(self: arhiplexpy.solve_result, value: int) -> None"""
    def __eq__(self, other: object) -> bool:
        """__eq__(self: object, other: object) -> bool"""
    def __hash__(self) -> int:
        """__hash__(self: object) -> int"""
    def __index__(self) -> int:
        """__index__(self: arhiplexpy.solve_result) -> int"""
    def __int__(self) -> int:
        """__int__(self: arhiplexpy.solve_result) -> int"""
    def __ne__(self, other: object) -> bool:
        """__ne__(self: object, other: object) -> bool"""
    @property
    def name(self) -> str:
        """name(self: handle) -> str

        name(self: handle) -> str
        """
    @property
    def value(self) -> int:
        """(arg0: arhiplexpy.solve_result) -> int"""

class variable_type:
    """Members:

      continuous

      binary

      integer

      semicontinuous

      semiinteger"""
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    binary: ClassVar[variable_type] = ...
    continuous: ClassVar[variable_type] = ...
    integer: ClassVar[variable_type] = ...
    semicontinuous: ClassVar[variable_type] = ...
    semiinteger: ClassVar[variable_type] = ...
    def __init__(self, value: int) -> None:
        """__init__(self: arhiplexpy.variable_type, value: int) -> None"""
    def __eq__(self, other: object) -> bool:
        """__eq__(self: object, other: object) -> bool"""
    def __hash__(self) -> int:
        """__hash__(self: object) -> int"""
    def __index__(self) -> int:
        """__index__(self: arhiplexpy.variable_type) -> int"""
    def __int__(self) -> int:
        """__int__(self: arhiplexpy.variable_type) -> int"""
    def __ne__(self, other: object) -> bool:
        """__ne__(self: object, other: object) -> bool"""
    @property
    def name(self) -> str:
        """name(self: handle) -> str

        name(self: handle) -> str
        """
    @property
    def value(self) -> int:
        """(arg0: arhiplexpy.variable_type) -> int"""

def sum(iterable: Iterable) -> float | Variable | LinearExpression | QuadExpression | GeneralExpression:
    """sum(iterable: Iterable) -> Union[float, arhiplexpy.Variable, arhiplexpy.LinearExpression, arhiplexpy.QuadExpression, arhiplexpy.GeneralExpression]

    Суммирует переменные и/или линейные выражения
                       :return: объект выражения
    """
