import os
import sys
from setuptools import setup, find_packages

def get_pyversion():
  pyver = sys.version_info

  if pyver.major == 3 and pyver.minor in [7, 8, 9, 10, 11, 12]:
     print("Install 'arhiplexpy' for Python {0}.{1}".format(pyver.major, pyver.minor))
  else:
     raise RuntimeError("Unsupported Python {0}.{1} for 'arhiplexpy'".format(pyver.major, pyver.minor))

  return "{}{}".format(pyver.major, pyver.minor)

with open('version.txt', 'r') as file:
    arhiplex_version = file.read()
    print(f'Arhiplex version : {arhiplex_version}')
    pkgpath = os.path.join(get_pyversion(), 'arhiplexpy')
    print(pkgpath)

try:
    setup(name='arhiplexpy',
          version=arhiplex_version,
          packages=['arhiplexpy'],
          include_package_data=True,
          package_dir={'arhiplexpy': pkgpath},
          package_data={'arhiplexpy': ['*']},
          description='Python interface to Arhiplex',
          maintainer_email='',
          platforms=[],
          license='private',
          url='https://arhitex.com/',
          python_requires='>=3.7'
          )
finally:
    pass